"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MemoryUsagePage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _mlDatePicker = require("@kbn/ml-date-picker");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _nodes_overview = require("./nodes_overview");
var _page_header = require("../components/page_header");
var _memory_tree_map = require("./memory_tree_map");
var _use_is_serverless = require("../contexts/kibana/use_is_serverless");
var _saved_objects_warning = require("../components/saved_objects_warning");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
var TAB;
(function (TAB) {
  TAB[TAB["NODES"] = 0] = "NODES";
  TAB[TAB["MEMORY_USAGE"] = 1] = "MEMORY_USAGE";
})(TAB || (TAB = {}));
const MemoryUsagePage = () => {
  const serverless = (0, _use_is_serverless.useIsServerless)();
  const [selectedTab, setSelectedTab] = (0, _react.useState)(TAB.NODES);
  (0, _mlDatePicker.useTimefilter)({
    timeRangeSelector: false,
    autoRefreshSelector: true
  });
  const refresh = (0, _react.useCallback)(() => {
    _mlDatePicker.mlTimefilterRefresh$.next({
      lastRefresh: Date.now()
    });
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    wrap: false,
    alignItems: 'center',
    gutterSize: 'm'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.memoryUsage.memoryUsageHeader",
    defaultMessage: "Memory Usage"
  })))), /*#__PURE__*/_react.default.createElement(_saved_objects_warning.SavedObjectsWarning, {
    onCloseFlyout: refresh
  }), serverless ? /*#__PURE__*/_react.default.createElement(_memory_tree_map.JobMemoryTreeMap, null) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: selectedTab === TAB.NODES,
    onClick: () => setSelectedTab(TAB.NODES)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.memoryUsage.nodesTab",
    defaultMessage: "Nodes"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: selectedTab === TAB.MEMORY_USAGE,
    onClick: () => setSelectedTab(TAB.MEMORY_USAGE)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.memoryUsage.memoryTab",
    defaultMessage: "Memory usage"
  }))), selectedTab === TAB.NODES ? /*#__PURE__*/_react.default.createElement(_nodes_overview.NodesList, null) : /*#__PURE__*/_react.default.createElement(_memory_tree_map.MemoryPage, null)));
};
exports.MemoryUsagePage = MemoryUsagePage;