"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTableState = useTableState;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useTableState(items, initialSortField) {
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const [pageSize, setPageSize] = (0, _react.useState)(10);
  const [sortField, setSortField] = (0, _react.useState)(initialSortField);
  const [sortDirection, setSortDirection] = (0, _react.useState)('asc');
  const onTableChange = ({
    page = {
      index: 0,
      size: 10
    },
    sort = {
      field: sortField,
      direction: sortDirection
    }
  }) => {
    const {
      index,
      size
    } = page;
    setPageIndex(index);
    setPageSize(size);
    const {
      field,
      direction
    } = sort;
    setSortField(field);
    setSortDirection(direction);
  };
  const pagination = {
    pageIndex,
    pageSize,
    totalItemCount: (items !== null && items !== void 0 ? items : []).length,
    pageSizeOptions: [10, 20, 50],
    showPerPageOptions: true
  };
  const sorting = {
    sort: {
      field: sortField,
      direction: sortDirection
    }
  };
  return {
    onTableChange,
    pagination,
    sorting,
    setPageIndex
  };
}