"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpaceManagement = exports.RefreshButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _management = require("../../../../../services/ml_api_service/management");
var _columns = require("./columns");
var _ml_saved_objects_spaces_list = require("../../../../../components/ml_saved_objects_spaces_list");
var _filters = require("./filters");
var _use_table_state = require("./use_table_state");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SpaceManagement = ({
  spacesApi,
  setCurrentTab
}) => {
  const {
    getList
  } = (0, _management.useManagementApiService)();
  const [currentTabId, setCurrentTabId] = (0, _react.useState)('anomaly-detector');
  const [items, setItems] = (0, _react.useState)();
  const [columns, setColumns] = (0, _react.useState)([]);
  const [filters, setFilters] = (0, _react.useState)();
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const {
    onTableChange,
    pagination,
    sorting,
    setPageIndex
  } = (0, _use_table_state.useTableState)(items !== null && items !== void 0 ? items : [], 'id');
  const isMounted = (0, _react.useRef)(true);
  (0, _react.useEffect)(() => {
    return () => {
      isMounted.current = false;
    };
  }, []);
  const loadingTab = (0, _react.useRef)(null);
  const refresh = (0, _react.useCallback)(tabId => {
    loadingTab.current = tabId;
    setIsLoading(true);
    getList(tabId).then(jobList => {
      if (isMounted.current && tabId === loadingTab.current) {
        setItems(jobList);
        setIsLoading(false);
        setFilters((0, _filters.getFilters)(tabId, jobList));
      }
    }).catch(() => {
      if (isMounted.current) {
        setItems([]);
        setFilters(undefined);
        setIsLoading(false);
      }
    });
  }, [getList, loadingTab]);
  (0, _react.useEffect)(function refreshOnTabChange() {
    setItems(undefined);
    setColumns(createColumns());
    setCurrentTab(currentTabId);
    refresh(currentTabId);
    setPageIndex(0);
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [currentTabId]);
  const createColumns = (0, _react.useCallback)(() => {
    return [...(0, _columns.getColumns)(currentTabId), ...(spacesApi !== undefined ? [{
      name: _i18n.i18n.translate('xpack.ml.management.spaceManagementTableColumn.spaces', {
        defaultMessage: 'spaces'
      }),
      'data-test-subj': 'mlSpaceManagementTableColumnSpaces',
      sortable: true,
      truncateText: true,
      align: 'right',
      width: '10%',
      render: item => {
        var _item$spaces;
        return /*#__PURE__*/_react.default.createElement(_ml_saved_objects_spaces_list.MLSavedObjectsSpacesList, {
          spacesApi: spacesApi,
          spaceIds: (_item$spaces = item.spaces) !== null && _item$spaces !== void 0 ? _item$spaces : [],
          id: item.id,
          mlSavedObjectType: currentTabId,
          refresh: refresh.bind(null, currentTabId)
        });
      }
    }] : [])];
  }, [currentTabId, spacesApi, refresh]);
  const getTable = (0, _react.useCallback)(() => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
      size: "xs",
      color: "accent"
    }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), items === undefined ? null : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: 'flexEnd',
      gutterSize: 'none'
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(RefreshButton, {
      onRefreshClick: refresh.bind(null, currentTabId),
      isRefreshing: isLoading
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
      "data-test-subj": `mlSpacesManagementTable-${currentTabId} ${isLoading ? 'loading' : 'loaded'}`,
      items: items,
      columns: columns,
      search: {
        box: {
          incremental: true
        },
        filters
      },
      onTableChange: onTableChange,
      pagination: pagination,
      sorting: sorting,
      rowProps: item => ({
        'data-test-subj': `mlSpacesManagementTable-${currentTabId} row-${item.id}`
      })
    })));
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [items, columns, isLoading, filters, currentTabId, refresh, onTableChange]);
  const tabs = (0, _react.useMemo)(() => [{
    'data-test-subj': 'mlStackManagementAnomalyDetectionTab',
    id: 'anomaly-detector',
    name: _i18n.i18n.translate('xpack.ml.management.list.anomalyDetectionTab', {
      defaultMessage: 'Anomaly detection'
    }),
    content: getTable()
  }, {
    'data-test-subj': 'mlStackManagementAnalyticsTab',
    id: 'data-frame-analytics',
    name: _i18n.i18n.translate('xpack.ml.management.list.analyticsTab', {
      defaultMessage: 'Analytics'
    }),
    content: getTable()
  }, {
    'data-test-subj': 'mlStackManagementTrainedModelsTab',
    id: 'trained-model',
    name: _i18n.i18n.translate('xpack.ml.management.list.trainedModelsTab', {
      defaultMessage: 'Trained models'
    }),
    content: getTable()
  }], [getTable]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    "data-test-subj": "mlSpacesManagementTable",
    onTabClick: ({
      id
    }) => {
      setCurrentTabId(id);
    },
    size: "s",
    tabs: tabs,
    initialSelectedTab: tabs[0]
  });
};
exports.SpaceManagement = SpaceManagement;
const RefreshButton = ({
  onRefreshClick,
  isRefreshing
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
  "data-test-subj": `mlRefreshJobListButton${isRefreshing ? ' loading' : ' loaded'}`,
  onClick: onRefreshClick,
  isLoading: isRefreshing,
  iconType: 'refresh',
  iconSide: 'left',
  iconSize: 'm'
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.ml.management.list.refreshButtonLabel",
  defaultMessage: "Refresh"
}));
exports.RefreshButton = RefreshButton;