"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFilters = getFilters;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getFilters(mlSavedObjectType, items) {
  switch (mlSavedObjectType) {
    case 'anomaly-detector':
      return createOptions(items, [['jobState', _i18n.i18n.translate('xpack.ml.management.spaceManagementFilters.ad.jobState', {
        defaultMessage: 'Job state'
      })], ['datafeedState', _i18n.i18n.translate('xpack.ml.management.spaceManagementFilters.ad.datafeedState', {
        defaultMessage: 'Datafeed state'
      })]]);
    case 'data-frame-analytics':
      return createOptions(items, [['job_type', _i18n.i18n.translate('xpack.ml.management.spaceManagementFilters.dfa.job_type', {
        defaultMessage: 'Type'
      })], ['state', _i18n.i18n.translate('xpack.ml.management.spaceManagementFilters.dfa.state', {
        defaultMessage: 'Status'
      })]]);
    case 'trained-model':
      return createOptions(items, [['type', _i18n.i18n.translate('xpack.ml.management.spaceManagementFilters.trainedModels.type', {
        defaultMessage: 'Type'
      })]]);
    default:
      return undefined;
  }
}
function createOptions(items, matches) {
  return matches.map(([field, name]) => {
    const options = [...new Set(items.map(j => j[field]).flat())].sort((a, b) => a.localeCompare(b)).map(t => ({
      value: t,
      name: t
    }));
    return {
      type: 'field_value_selection',
      multiSelect: 'or',
      field,
      name,
      options
    };
  });
}