"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlClientLicense = void 0;
var _locator = require("../../../common/constants/locator");
var _license = require("../../../common/license");
var _expired_warning = require("./expired_warning");
var _app = require("../../../common/constants/app");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class MlClientLicense extends _license.MlLicense {
  constructor(application) {
    super();
    this.application = application;
  }
  redirectToKibana() {
    this.application.navigateToApp('home');
    return Promise.reject();
  }
  redirectToBasic() {
    this.application.navigateToApp(_app.PLUGIN_ID, {
      path: _locator.ML_PAGES.DATA_VISUALIZER
    });
    return Promise.reject();
  }
  fullLicenseResolver() {
    if (this.isMlEnabled() === false || this.isMinimumLicense() === false) {
      // ML is not enabled or the license isn't at least basic
      return this.redirectToKibana();
    }
    if (this.isFullLicense() === false) {
      // ML is enabled, but only with a basic or gold license
      return this.redirectToBasic();
    }

    // ML is enabled
    if (this.hasLicenseExpired()) {
      (0, _expired_warning.showExpiredLicenseWarning)();
    }
    return Promise.resolve();
  }
  basicLicenseResolver() {
    if (this.isMlEnabled() === false || this.isMinimumLicense() === false) {
      // ML is not enabled or the license isn't at least basic
      return this.redirectToKibana();
    }

    // ML is enabled
    if (this.hasLicenseExpired()) {
      (0, _expired_warning.showExpiredLicenseWarning)();
    }
    return Promise.resolve();
  }
}
exports.MlClientLicense = MlClientLicense;