"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.showExpiredLicenseWarning = showExpiredLicenseWarning;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _dependency_cache = require("../util/dependency_cache");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

let expiredLicenseBannerId;
function showExpiredLicenseWarning() {
  if (expiredLicenseBannerId === undefined) {
    const message = _i18n.i18n.translate('xpack.ml.checkLicense.licenseHasExpiredMessage', {
      defaultMessage: 'Your Machine Learning license has expired.'
    });
    // Only show the banner once with no way to dismiss it
    const overlays = (0, _dependency_cache.getOverlays)();
    const theme = (0, _dependency_cache.getTheme)();
    expiredLicenseBannerId = overlays.banners.add((0, _public.toMountPoint)((0, _public.wrapWithTheme)( /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      iconType: "iInCircle",
      color: "warning",
      title: message
    }), theme.theme$)));
  }
}