"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WizardSteps = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _job_creator_context = require("../components/job_creator_context");
var _kibana = require("../../../../contexts/kibana");
var _field_stats_flyout = require("../../../../components/field_stats_flyout");
var _step_types = require("../components/step_types");
var _time_range_step = require("../components/time_range_step");
var _pick_fields_step = require("../components/pick_fields_step");
var _job_details_step = require("../components/job_details_step");
var _validation_step = require("../components/validation_step");
var _summary_step = require("../components/summary_step");
var _datafeed_step = require("../components/datafeed_step");
var _ml = require("../../../../contexts/ml");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WizardSteps = ({
  currentStep,
  setCurrentStep
}) => {
  const mlContext = (0, _ml.useMlContext)();
  const {
    services
  } = (0, _kibana.useMlKibana)();
  const fieldStatsServices = (0, _react.useMemo)(() => {
    const {
      uiSettings,
      data,
      fieldFormats,
      charts
    } = services;
    return {
      uiSettings,
      dataViews: data.dataViews,
      data,
      fieldFormats,
      charts
    };
  }, [services]);
  const {
    jobCreator,
    jobCreatorUpdated
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const [start, setStart] = (0, _react.useState)(jobCreator === null || jobCreator === void 0 ? void 0 : jobCreator.start);
  const [end, setEnd] = (0, _react.useState)(jobCreator === null || jobCreator === void 0 ? void 0 : jobCreator.end);
  (0, _react.useEffect)(() => {
    if (jobCreator && jobCreator.start !== start || jobCreator.end !== end) {
      setStart(jobCreator.start);
      setEnd(jobCreator.end);
    }

    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreatorUpdated]);

  // Format timestamp to ISO formatted date strings
  const timeRangeMs = (0, _react.useMemo)(() => {
    // If time range is available via jobCreator, use that
    // else mimic Discover and set timeRange to be now for data view without time field
    return start && end ? {
      from: start,
      to: end
    } : undefined;
  }, [start, end]);

  // store whether the advanced and additional sections have been expanded.
  // has to be stored at this level to ensure it's remembered on wizard step change
  const [advancedExpanded, setAdvancedExpanded] = (0, _react.useState)(false);
  const [additionalExpanded, setAdditionalExpanded] = (0, _react.useState)(false);
  function getSummaryStepTitle() {
    if (mlContext.selectedSavedSearch) {
      var _mlContext$selectedSa;
      return _i18n.i18n.translate('xpack.ml.newJob.wizard.stepComponentWrapper.summaryTitleSavedSearch', {
        defaultMessage: 'New job from saved search {title}',
        values: {
          title: (_mlContext$selectedSa = mlContext.selectedSavedSearch.title) !== null && _mlContext$selectedSa !== void 0 ? _mlContext$selectedSa : ''
        }
      });
    } else if (mlContext.currentDataView.id !== undefined) {
      return _i18n.i18n.translate('xpack.ml.newJob.wizard.stepComponentWrapper.summaryTitleDataView', {
        defaultMessage: 'New job from data view {dataViewName}',
        values: {
          dataViewName: mlContext.currentDataView.getName()
        }
      });
    }
    return '';
  }
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, currentStep === _step_types.WIZARD_STEPS.TIME_RANGE && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(Title, {
    "data-test-subj": "mlJobWizardStepTitleTimeRange"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.stepComponentWrapper.timeRangeTitle",
    defaultMessage: "Time range"
  })), /*#__PURE__*/_react.default.createElement(_time_range_step.TimeRangeStep, {
    isCurrentStep: currentStep === _step_types.WIZARD_STEPS.TIME_RANGE,
    setCurrentStep: setCurrentStep
  })), currentStep === _step_types.WIZARD_STEPS.ADVANCED_CONFIGURE_DATAFEED && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(Title, {
    "data-test-subj": "mlJobWizardStepTitleConfigureDatafeed"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.stepComponentWrapper.configureDatafeedTitle",
    defaultMessage: "Configure datafeed"
  })), /*#__PURE__*/_react.default.createElement(_datafeed_step.DatafeedStep, {
    isCurrentStep: currentStep === _step_types.WIZARD_STEPS.ADVANCED_CONFIGURE_DATAFEED,
    setCurrentStep: setCurrentStep
  })), currentStep === _step_types.WIZARD_STEPS.PICK_FIELDS && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_field_stats_flyout.FieldStatsFlyoutProvider, {
    dataView: mlContext.currentDataView,
    fieldStatsServices: fieldStatsServices,
    timeRangeMs: timeRangeMs,
    dslQuery: jobCreator.query
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(Title, {
    "data-test-subj": "mlJobWizardStepTitlePickFields"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.stepComponentWrapper.pickFieldsTitle",
    defaultMessage: "Choose fields"
  })))), /*#__PURE__*/_react.default.createElement(_pick_fields_step.PickFieldsStep, {
    isCurrentStep: currentStep === _step_types.WIZARD_STEPS.PICK_FIELDS,
    setCurrentStep: setCurrentStep
  })))), currentStep === _step_types.WIZARD_STEPS.JOB_DETAILS && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(Title, {
    "data-test-subj": "mlJobWizardStepTitleJobDetails"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.stepComponentWrapper.jobDetailsTitle",
    defaultMessage: "Job details"
  })), /*#__PURE__*/_react.default.createElement(_job_details_step.JobDetailsStep, {
    isCurrentStep: currentStep === _step_types.WIZARD_STEPS.JOB_DETAILS,
    setCurrentStep: setCurrentStep,
    advancedExpanded: advancedExpanded,
    setAdvancedExpanded: setAdvancedExpanded,
    additionalExpanded: additionalExpanded,
    setAdditionalExpanded: setAdditionalExpanded
  })), currentStep === _step_types.WIZARD_STEPS.VALIDATION && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(Title, {
    "data-test-subj": "mlJobWizardStepTitleValidation"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.stepComponentWrapper.validationTitle",
    defaultMessage: "Validation"
  })), /*#__PURE__*/_react.default.createElement(_validation_step.ValidationStep, {
    isCurrentStep: currentStep === _step_types.WIZARD_STEPS.VALIDATION,
    setCurrentStep: setCurrentStep
  })), currentStep === _step_types.WIZARD_STEPS.SUMMARY && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(Title, {
    "data-test-subj": "mlJobWizardStepTitleSummary"
  }, getSummaryStepTitle()), /*#__PURE__*/_react.default.createElement(_summary_step.SummaryStep, {
    isCurrentStep: currentStep === _step_types.WIZARD_STEPS.SUMMARY,
    setCurrentStep: setCurrentStep
  })));
};
exports.WizardSteps = WizardSteps;
const Title = ({
  'data-test-subj': dataTestSubj,
  children
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    "data-test-subj": dataTestSubj
  }, children)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
};