"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.preConfiguredJobRedirect = preConfiguredJobRedirect;
var _job_service = require("../../../../services/job_service");
var _new_job = require("../../../../../../common/constants/new_job");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function preConfiguredJobRedirect(dataViewsContract, basePath, navigateToUrl) {
  const {
    createdBy,
    job,
    datafeed
  } = _job_service.mlJobService.tempJobCloningObjects;
  if (job && datafeed) {
    const dataViewId = await getDataViewIdFromName(datafeed, dataViewsContract);
    if (dataViewId === null) {
      return Promise.resolve();
    }
    try {
      const redirectUrl = await getWizardUrlFromCloningJob(createdBy, dataViewId);
      await navigateToUrl(`${basePath}/app/ml/${redirectUrl}`);
      return Promise.reject();
    } catch (error) {
      return Promise.resolve();
    }
  } else {
    // no job to clone
    // don't redirect
    return Promise.resolve();
  }
}
async function getWizardUrlFromCloningJob(createdBy, dataViewId) {
  const created = createdBy;
  let page = '';
  switch (created) {
    case _new_job.CREATED_BY_LABEL.SINGLE_METRIC:
    case _new_job.CREATED_BY_LABEL.SINGLE_METRIC_FROM_LENS:
      page = _new_job.JOB_TYPE.SINGLE_METRIC;
      break;
    case _new_job.CREATED_BY_LABEL.MULTI_METRIC:
    case _new_job.CREATED_BY_LABEL.MULTI_METRIC_FROM_LENS:
      page = _new_job.JOB_TYPE.MULTI_METRIC;
      break;
    case _new_job.CREATED_BY_LABEL.POPULATION:
      page = _new_job.JOB_TYPE.POPULATION;
      break;
    case _new_job.CREATED_BY_LABEL.CATEGORIZATION:
      page = _new_job.JOB_TYPE.CATEGORIZATION;
      break;
    case _new_job.CREATED_BY_LABEL.RARE:
      page = _new_job.JOB_TYPE.RARE;
      break;
    case _new_job.CREATED_BY_LABEL.GEO:
      page = _new_job.JOB_TYPE.GEO;
      break;
    default:
      page = _new_job.JOB_TYPE.ADVANCED;
      break;
  }
  return `jobs/new_job/${page}?index=${dataViewId}&_g=()`;
}
async function getDataViewIdFromName(datafeed, dataViewsContract) {
  var _dv$id;
  if (dataViewsContract === null) {
    throw new Error('Data views are not initialized!');
  }
  const [dv] = await (dataViewsContract === null || dataViewsContract === void 0 ? void 0 : dataViewsContract.find(datafeed.indices.join(',')));
  if (!dv) {
    return null;
  }
  return (_dv$id = dv.id) !== null && _dv$id !== void 0 ? _dv$id : dv.title;
}