"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PostSaveOptions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlErrorUtils = require("@kbn/ml-error-utils");
var _kibana = require("../../../../../../../contexts/kibana");
var _job_creator_context = require("../../../job_creator_context");
var _states = require("../../../../../../../../../common/constants/states");
var _ml_alerting_flyout = require("../../../../../../../../alerting/ml_alerting_flyout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PostSaveOptions = ({
  jobRunner
}) => {
  const {
    services: {
      notifications
    }
  } = (0, _kibana.useMlKibana)();
  const {
    jobCreator
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const [datafeedState, setDatafeedState] = (0, _react.useState)(_states.DATAFEED_STATE.STOPPED);
  const [alertFlyoutVisible, setAlertFlyoutVisible] = (0, _react.useState)(false);
  async function startJobInRealTime() {
    const {
      toasts
    } = notifications;
    setDatafeedState(_states.DATAFEED_STATE.STARTING);
    if (jobRunner !== null) {
      try {
        const started = await jobRunner.startDatafeedInRealTime(true);
        setDatafeedState(started === true ? _states.DATAFEED_STATE.STARTED : _states.DATAFEED_STATE.STOPPED);
        toasts.addSuccess({
          title: _i18n.i18n.translate('xpack.ml.newJob.wizard.summaryStep.postSaveOptions.startJobInRealTimeSuccess', {
            defaultMessage: `Job {jobId} started`,
            values: {
              jobId: jobCreator.jobId
            }
          })
        });
      } catch (error) {
        setDatafeedState(_states.DATAFEED_STATE.STOPPED);
        toasts.addDanger({
          title: _i18n.i18n.translate('xpack.ml.newJob.wizard.summaryStep.postSaveOptions.startJobInRealTimeError', {
            defaultMessage: `Error starting job`
          }),
          text: (0, _mlErrorUtils.extractErrorMessage)(error)
        });
      }
    }
  }
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isDisabled: datafeedState === _states.DATAFEED_STATE.STARTING || datafeedState === _states.DATAFEED_STATE.STARTED,
    onClick: startJobInRealTime,
    "data-test-subj": "mlJobWizardButtonRunInRealTime"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.summaryStep.postSaveOptions.startJobInRealTime",
    defaultMessage: "Start job running in real time"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isDisabled: datafeedState === _states.DATAFEED_STATE.STOPPED || datafeedState === _states.DATAFEED_STATE.STARTING,
    onClick: setAlertFlyoutVisible.bind(null, true),
    "data-test-subj": "mlJobWizardButtonCreateAlert"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.summaryStep.postSaveOptions.createAlert",
    defaultMessage: "Create alert rule"
  }))), datafeedState === _states.DATAFEED_STATE.STARTED && alertFlyoutVisible && /*#__PURE__*/_react.default.createElement(_ml_alerting_flyout.MlAnomalyAlertFlyout, {
    jobIds: [jobCreator.jobId],
    onCloseFlyout: setAlertFlyoutVisible.bind(null, false)
  }));
};
exports.PostSaveOptions = PostSaveOptions;