"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetectorChart = void 0;
var _react = _interopRequireWildcard(require("react"));
var _job_creator_context = require("../../../job_creator_context");
var _new_job = require("../../../../../../../../../common/constants/new_job");
var _single_metric_view = require("../../../pick_fields_step/components/single_metric_view");
var _multi_metric_view = require("../../../pick_fields_step/components/multi_metric_view");
var _population_view = require("../../../pick_fields_step/components/population_view");
var _advanced_view = require("../../../pick_fields_step/components/advanced_view");
var _categorization_view = require("../../../pick_fields_step/components/categorization_view");
var _rare_view = require("../../../pick_fields_step/components/rare_view");
var _geo_view = require("../../../pick_fields_step/components/geo_view");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DetectorChart = () => {
  const {
    jobCreator
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, jobCreator.type === _new_job.JOB_TYPE.SINGLE_METRIC && /*#__PURE__*/_react.default.createElement(_single_metric_view.SingleMetricView, {
    isActive: false
  }), jobCreator.type === _new_job.JOB_TYPE.MULTI_METRIC && /*#__PURE__*/_react.default.createElement(_multi_metric_view.MultiMetricView, {
    isActive: false
  }), jobCreator.type === _new_job.JOB_TYPE.POPULATION && /*#__PURE__*/_react.default.createElement(_population_view.PopulationView, {
    isActive: false
  }), jobCreator.type === _new_job.JOB_TYPE.ADVANCED && /*#__PURE__*/_react.default.createElement(_advanced_view.AdvancedView, {
    isActive: false
  }), jobCreator.type === _new_job.JOB_TYPE.CATEGORIZATION && /*#__PURE__*/_react.default.createElement(_categorization_view.CategorizationView, {
    isActive: false
  }), jobCreator.type === _new_job.JOB_TYPE.RARE && /*#__PURE__*/_react.default.createElement(_rare_view.RareView, {
    isActive: false
  }), jobCreator.type === _new_job.JOB_TYPE.GEO && /*#__PURE__*/_react.default.createElement(_geo_view.GeoView, {
    isActive: false
  }));
};
exports.DetectorChart = DetectorChart;