"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SparseDataSwitch = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _job_creator_context = require("../../../job_creator_context");
var _description = require("./description");
var _aggregation_types = require("../../../../../../../../../common/constants/aggregation_types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SparseDataSwitch = () => {
  const {
    jobCreator,
    jobCreatorUpdated,
    jobCreatorUpdate
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const [sparseData, setSparseData] = (0, _react.useState)(jobCreator.sparseData);
  const [enabled, setEnabled] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    jobCreator.sparseData = sparseData;
    jobCreatorUpdate();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [sparseData]);
  (0, _react.useEffect)(() => {
    const aggs = [_aggregation_types.ES_AGGREGATION.COUNT, _aggregation_types.ES_AGGREGATION.SUM];
    const isCountOrSum = jobCreator.aggregations.some(agg => agg.dslName !== null && aggs.includes(agg.dslName));
    setEnabled(isCountOrSum);
    if (isCountOrSum === false && sparseData === true) {
      setSparseData(false);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreatorUpdated]);
  function toggleSparseData() {
    setSparseData(!sparseData);
  }
  return /*#__PURE__*/_react.default.createElement(_description.Description, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    name: "switch",
    disabled: enabled === false,
    checked: sparseData,
    onChange: toggleSparseData,
    "data-test-subj": "mlJobWizardSwitchSparseData",
    label: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.sparseData.title', {
      defaultMessage: 'Sparse data'
    })
  }));
};
exports.SparseDataSwitch = SparseDataSwitch;