"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RareDetectorsSummary = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _job_creator_context = require("../../../job_creator_context");
var _event_rate_chart = require("../../../charts/event_rate_chart");
var _rare_view = require("./rare_view");
var _detector_description = require("./detector_description");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DTR_IDX = 0;
const RareDetectorsSummary = () => {
  const {
    jobCreator: jc,
    chartLoader,
    resultsLoader,
    chartInterval,
    jobCreatorUpdated
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const jobCreator = jc;
  const [loadingData, setLoadingData] = (0, _react.useState)(false);
  const [anomalyData, setAnomalyData] = (0, _react.useState)([]);
  const [eventRateChartData, setEventRateChartData] = (0, _react.useState)([]);
  const [jobIsRunning, setJobIsRunning] = (0, _react.useState)(false);
  const rareDetectorType = (0, _react.useMemo)(() => {
    if (jobCreator.rareField !== null) {
      if (jobCreator.populationField === null) {
        return _rare_view.RARE_DETECTOR_TYPE.RARE;
      } else {
        return jobCreator.frequentlyRare ? _rare_view.RARE_DETECTOR_TYPE.FREQ_RARE_POPULATION : _rare_view.RARE_DETECTOR_TYPE.RARE_POPULATION;
      }
    } else {
      return _rare_view.RARE_DETECTOR_TYPE.RARE;
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreatorUpdated]);
  function setResultsWrapper(results) {
    const anomalies = results.anomalies[DTR_IDX];
    if (anomalies !== undefined) {
      setAnomalyData(anomalies);
    }
  }
  function watchProgress(progress) {
    setJobIsRunning(progress > 0);
  }
  (0, _react.useEffect)(() => {
    // subscribe to progress and results
    const resultsSubscription = resultsLoader.subscribeToResults(setResultsWrapper);
    jobCreator.subscribeToProgress(watchProgress);
    loadChart();
    return () => {
      resultsSubscription.unsubscribe();
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  async function loadChart() {
    setLoadingData(true);
    try {
      var _jobCreator$runtimeMa;
      const resp = await chartLoader.loadEventRateChart(jobCreator.start, jobCreator.end, chartInterval.getInterval().asMilliseconds(), (_jobCreator$runtimeMa = jobCreator.runtimeMappings) !== null && _jobCreator$runtimeMa !== void 0 ? _jobCreator$runtimeMa : undefined, jobCreator.datafeedConfig.indices_options);
      setEventRateChartData(resp);
    } catch (error) {
      setEventRateChartData([]);
    }
    setLoadingData(false);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_detector_description.DetectorDescription, {
    detectorType: rareDetectorType
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_event_rate_chart.EventRateChart, {
    eventRateChartData: eventRateChartData,
    anomalyData: anomalyData,
    height: "300px",
    width: "100%",
    showAxis: true,
    loading: loadingData,
    fadeChart: jobIsRunning
  }));
};
exports.RareDetectorsSummary = RareDetectorsSummary;