"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RareDetector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _job_creator_context = require("../../../job_creator_context");
var _detector_cards = require("./detector_cards");
var _rare_view = require("../rare_view");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RareDetector = ({
  onChange
}) => {
  const {
    jobCreator: jc,
    jobCreatorUpdate
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const jobCreator = jc;
  const [rareDetectorType, setRareDetectorType] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    if (jobCreator.rareField !== null) {
      if (jobCreator.populationField === null) {
        setRareDetectorType(_rare_view.RARE_DETECTOR_TYPE.RARE);
      } else {
        setRareDetectorType(jobCreator.frequentlyRare ? _rare_view.RARE_DETECTOR_TYPE.FREQ_RARE_POPULATION : _rare_view.RARE_DETECTOR_TYPE.RARE_POPULATION);
      }
    } else {
      setRareDetectorType(_rare_view.RARE_DETECTOR_TYPE.RARE);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  (0, _react.useEffect)(() => {
    if (rareDetectorType !== null) {
      onChange(rareDetectorType);
      if (rareDetectorType === _rare_view.RARE_DETECTOR_TYPE.RARE && jobCreator.populationField !== null) {
        jobCreator.removePopulationField();
      }
      jobCreator.frequentlyRare = rareDetectorType === _rare_view.RARE_DETECTOR_TYPE.FREQ_RARE_POPULATION;
      jobCreatorUpdate();
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [rareDetectorType]);
  function onRareSelection() {
    setRareDetectorType(_rare_view.RARE_DETECTOR_TYPE.RARE);
  }
  function onRareInPopulationSelection() {
    setRareDetectorType(_rare_view.RARE_DETECTOR_TYPE.RARE_POPULATION);
  }
  function onFreqRareInPopulationSelection() {
    setRareDetectorType(_rare_view.RARE_DETECTOR_TYPE.FREQ_RARE_POPULATION);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.pickFieldsStep.rareDetectorSelect.title",
    defaultMessage: "Rare detector"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l",
    style: {
      maxWidth: '824px'
    }
  }, /*#__PURE__*/_react.default.createElement(_detector_cards.RareCard, {
    onClick: onRareSelection,
    isSelected: rareDetectorType === _rare_view.RARE_DETECTOR_TYPE.RARE
  }), /*#__PURE__*/_react.default.createElement(_detector_cards.RareInPopulationCard, {
    onClick: onRareInPopulationSelection,
    isSelected: rareDetectorType === _rare_view.RARE_DETECTOR_TYPE.RARE_POPULATION
  }), /*#__PURE__*/_react.default.createElement(_detector_cards.FrequentlyRareInPopulationCard, {
    onClick: onFreqRareInPopulationSelection,
    isSelected: rareDetectorType === _rare_view.RARE_DETECTOR_TYPE.FREQ_RARE_POPULATION
  })));
};
exports.RareDetector = RareDetector;