"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PopulationFieldSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _split_field_select = require("../split_field_select");
var _job_creator_context = require("../../../job_creator_context");
var _fields_utils = require("../../../../../../../../../common/util/fields_utils");
var _new_job_capabilities_service = require("../../../../../../../services/new_job_capabilities/new_job_capabilities_service");
var _description = require("./description");
var _job_creator = require("../../../../../common/job_creator");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PopulationFieldSelector = () => {
  const {
    jobCreator: jc,
    jobCreatorUpdate,
    jobCreatorUpdated
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const jobCreator = jc;

  // eslint-disable-next-line react-hooks/exhaustive-deps
  const runtimeCategoryFields = (0, _react.useMemo)(() => (0, _fields_utils.filterCategoryFields)(jobCreator.runtimeFields), []);
  const allCategoryFields = (0, _react.useMemo)(() => [..._new_job_capabilities_service.newJobCapsService.categoryFields, ...runtimeCategoryFields].sort((a, b) => a.name.localeCompare(b.name)),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  const categoryFields = useFilteredCategoryFields(allCategoryFields, jobCreator, jobCreatorUpdated);
  const [populationField, setPopulationField] = (0, _react.useState)(jobCreator.populationField);
  (0, _react.useEffect)(() => {
    jobCreator.setPopulationField(populationField);
    // add the split field to the influencers
    if (populationField !== null && jobCreator.influencers.includes(populationField.name) === false) {
      jobCreator.addInfluencer(populationField.name);
    }
    jobCreatorUpdate();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [populationField]);
  (0, _react.useEffect)(() => {
    setPopulationField(jobCreator.populationField);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreatorUpdated]);
  return /*#__PURE__*/_react.default.createElement(_description.Description, null, /*#__PURE__*/_react.default.createElement(_split_field_select.SplitFieldSelect, {
    fields: categoryFields,
    changeHandler: setPopulationField,
    selectedField: populationField,
    isClearable: false,
    testSubject: "mlPopulationSplitFieldSelect"
  }));
};

// remove the rare (by) field from the by field options in the rare wizard
exports.PopulationFieldSelector = PopulationFieldSelector;
function useFilteredCategoryFields(allCategoryFields, jobCreator, jobCreatorUpdated) {
  const [fields, setFields] = (0, _react.useState)(allCategoryFields);
  (0, _react.useEffect)(() => {
    if ((0, _job_creator.isPopulationJobCreator)(jobCreator)) {
      setFields(allCategoryFields);
    } else {
      const rf = jobCreator.rareField;
      const sf = jobCreator.splitField;
      if (rf !== null || sf !== null) {
        setFields(allCategoryFields.filter(({
          name
        }) => name !== (rf === null || rf === void 0 ? void 0 : rf.name) && name !== (sf === null || sf === void 0 ? void 0 : sf.name)));
      } else {
        setFields(allCategoryFields);
      }
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreatorUpdated]);
  return fields;
}