"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopCategories = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _mlErrorUtils = require("@kbn/ml-error-utils");
var _job_creator_context = require("../../../job_creator_context");
var _ml_api_service = require("../../../../../../../services/ml_api_service");
var _toast_notification_service = require("../../../../../../../services/toast_notification_service");
var _categorization_job = require("../../../../../../../../../common/constants/categorization_job");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TopCategories = () => {
  const {
    displayErrorToast
  } = (0, _toast_notification_service.useToastNotificationService)();
  const {
    jobCreator: jc,
    resultsLoader
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const jobCreator = jc;
  const [tableRow, setTableRow] = (0, _react.useState)([]);
  const [totalCategories, setTotalCategories] = (0, _react.useState)(0);
  function setResultsWrapper(results) {
    loadTopCats();
  }
  async function loadTopCats() {
    try {
      const results = await _ml_api_service.ml.jobs.topCategories(jobCreator.jobId, _categorization_job.NUMBER_OF_CATEGORY_EXAMPLES);
      setTableRow(results.categories.map(c => {
        var _c$category$examples;
        return {
          count: c.count,
          example: (_c$category$examples = c.category.examples) !== null && _c$category$examples !== void 0 && _c$category$examples.length ? c.category.examples[0] : ''
        };
      }));
      setTotalCategories(results.total);
    } catch (e) {
      const error = (0, _mlErrorUtils.extractErrorProperties)(e);
      // might get 404 because job has not been created yet
      if (error.statusCode !== 404) {
        displayErrorToast(e);
      }
    }
  }
  (0, _react.useEffect)(() => {
    // subscribe to result updates
    const resultsSubscription = resultsLoader.subscribeToResults(setResultsWrapper);
    return () => {
      resultsSubscription.unsubscribe();
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const columns = [
  // only include counts if model plot is enabled
  ...(jobCreator.modelPlot ? [{
    field: 'count',
    name: 'count',
    width: '100px',
    render: count => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("code", null, count))
  }] : []), {
    field: 'example',
    name: 'Example',
    render: example => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("code", null, example))
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, totalCategories > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.pickFieldsStep.categorizationTotalCategories",
    defaultMessage: "Total categories: {totalCategories}",
    values: {
      totalCategories
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: columns,
    items: tableRow
  })));
};
exports.TopCategories = TopCategories;