"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExamplesValidCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _edit_categorization_analyzer_flyout = require("../../../common/edit_categorization_analyzer_flyout");
var _categorization_job = require("../../../../../../../../../common/constants/categorization_job");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const allChecksButtonContent = _i18n.i18n.translate('xpack.ml.newJob.wizard.jobDetailsStep.allChecksButton', {
  defaultMessage: 'View all checks performed'
});
const ExamplesValidCallout = ({
  overallValidStatus,
  validationChecks,
  categorizationAnalyzer
}) => {
  const analyzerUsed = /*#__PURE__*/_react.default.createElement(AnalyzerUsed, {
    categorizationAnalyzer: categorizationAnalyzer
  });
  let color = 'success';
  let title = _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.categorizationFieldCalloutTitle.valid', {
    defaultMessage: 'Selected category field is valid'
  });
  if (overallValidStatus === _categorization_job.CATEGORY_EXAMPLES_VALIDATION_STATUS.INVALID) {
    color = 'danger';
    title = _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.categorizationFieldCalloutTitle.invalid', {
      defaultMessage: 'Selected category field is invalid'
    });
  } else if (overallValidStatus === _categorization_job.CATEGORY_EXAMPLES_VALIDATION_STATUS.PARTIALLY_VALID) {
    color = 'warning';
    title = _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.categorizationFieldCalloutTitle.possiblyInvalid', {
      defaultMessage: 'Selected category field is possibly invalid'
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: color,
    title: title,
    "data-test-subj": `mlJobWizardCategorizationExamplesCallout ${overallValidStatus}`
  }, validationChecks.map((v, i) => /*#__PURE__*/_react.default.createElement("div", {
    key: i
  }, v.message)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), analyzerUsed, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "all-checks",
    buttonContent: allChecksButtonContent
  }, /*#__PURE__*/_react.default.createElement(AllValidationChecks, {
    validationChecks: validationChecks
  })));
};
exports.ExamplesValidCallout = ExamplesValidCallout;
const AnalyzerUsed = ({
  categorizationAnalyzer
}) => {
  let analyzer = '';
  if ((categorizationAnalyzer === null || categorizationAnalyzer === void 0 ? void 0 : categorizationAnalyzer.tokenizer) !== undefined) {
    analyzer = categorizationAnalyzer.tokenizer;
  } else if ((categorizationAnalyzer === null || categorizationAnalyzer === void 0 ? void 0 : categorizationAnalyzer.analyzer) !== undefined) {
    analyzer = categorizationAnalyzer.analyzer;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.pickFieldsStep.categorizationFieldAnalyzer",
    defaultMessage: "Analyzer used: {analyzer}",
    values: {
      analyzer
    }
  })), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_edit_categorization_analyzer_flyout.EditCategorizationAnalyzerFlyout, null)));
};
const AllValidationChecks = ({
  validationChecks
}) => {
  const list = Object.keys(_categorization_job.VALIDATION_CHECK_DESCRIPTION).map((k, i) => {
    const failedCheck = validationChecks.find(vc => vc.id === i);
    if (failedCheck !== undefined && (failedCheck === null || failedCheck === void 0 ? void 0 : failedCheck.valid) !== _categorization_job.CATEGORY_EXAMPLES_VALIDATION_STATUS.VALID) {
      return {
        iconType: 'cross',
        label: failedCheck.message,
        size: 's'
      };
    }
    return {
      iconType: 'check',
      label: _categorization_job.VALIDATION_CHECK_DESCRIPTION[i],
      size: 's'
    };
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    listItems: list,
    maxWidth: false
  });
};