"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CategorizationPerPartitionField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _job_creator_context = require("../../../job_creator_context");
var _job_creator = require("../../../../../common/job_creator");
var _description = require("./description");
var _categorization_per_partition_switch = require("./categorization_per_partition_switch");
var _categorization_stop_on_warn_switch = require("./categorization_stop_on_warn_switch");
var _categorization_per_partition_dropdown = require("./categorization_per_partition_dropdown");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CategorizationPerPartitionField = () => {
  const {
    jobCreator: jc,
    jobCreatorUpdated
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const jobCreator = jc;
  const [enablePerPartitionCategorization, setEnablePerPartitionCategorization] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    setEnablePerPartitionCategorization(jobCreator.perPartitionCategorization);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreatorUpdated]);
  return /*#__PURE__*/_react.default.createElement(_description.Description, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_categorization_per_partition_switch.CategorizationPerPartitionSwitch, null)), enablePerPartitionCategorization && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.wizard.extraStep.categorizationJob.stopOnWarnLabel",
      defaultMessage: "Stop on warn"
    })
  }, /*#__PURE__*/_react.default.createElement(_categorization_stop_on_warn_switch.CategorizationPerPartitionStopOnWarnSwitch, null))), (0, _job_creator.isCategorizationJobCreator)(jobCreator) && enablePerPartitionCategorization && /*#__PURE__*/_react.default.createElement(_categorization_per_partition_dropdown.CategorizationPerPartitionFieldDropdown, {
    setEnablePerPartitionCategorization: setEnablePerPartitionCategorization
  }));
};
exports.CategorizationPerPartitionField = CategorizationPerPartitionField;