"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CategorizationFieldSelect = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_field_stats_trigger = require("../../../../../../../components/field_stats_flyout/use_field_stats_trigger");
var _job_creator_context = require("../../../job_creator_context");
var _general = require("../../../../../common/job_creator/util/general");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CategorizationFieldSelect = ({
  fields,
  changeHandler,
  selectedField
}) => {
  const {
    jobCreator,
    jobCreatorUpdated
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const {
    renderOption,
    optionCss
  } = (0, _use_field_stats_trigger.useFieldStatsTrigger)();
  const options = (0, _react.useMemo)(() => [...(0, _general.createFieldOptions)(fields, jobCreator.additionalFields)].map(o => ({
    ...o,
    css: optionCss
  })),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [fields, jobCreatorUpdated, optionCss]);
  const selection = (0, _react.useMemo)(() => {
    const selectedOptions = [];
    if (selectedField !== null) {
      selectedOptions.push({
        label: selectedField
      });
    }
    return selectedOptions;
  }, [selectedField]);
  const onChange = (0, _react.useCallback)(selectedOptions => {
    var _ref;
    return changeHandler((_ref = selectedOptions[0] && selectedOptions[0].label) !== null && _ref !== void 0 ? _ref : null);
  }, [changeHandler]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    singleSelection: {
      asPlainText: true
    },
    options: options,
    selectedOptions: selection,
    onChange: onChange,
    isClearable: true,
    "data-test-subj": "mlCategorizationFieldNameSelect",
    renderOption: renderOption
  });
};
exports.CategorizationFieldSelect = CategorizationFieldSelect;