"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CategorizationDetector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _aggregation_types = require("../../../../../../../../../common/constants/aggregation_types");
var _job_creator_context = require("../../../job_creator_context");
var _detector_cards = require("./detector_cards");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CategorizationDetector = () => {
  const {
    jobCreator: jc,
    jobCreatorUpdate,
    jobCreatorUpdated
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const jobCreator = jc;
  const [categorizationDetectorType, setCategorizationDetectorType] = (0, _react.useState)(jobCreator.selectedDetectorType);
  (0, _react.useEffect)(() => {
    if (categorizationDetectorType !== jobCreator.selectedDetectorType) {
      jobCreator.setDetectorType(categorizationDetectorType);
      jobCreatorUpdate();
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [categorizationDetectorType]);
  (0, _react.useEffect)(() => {
    setCategorizationDetectorType(jobCreator.selectedDetectorType);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreatorUpdated]);
  function onCountSelection() {
    setCategorizationDetectorType(_aggregation_types.ML_JOB_AGGREGATION.COUNT);
  }
  function onRareSelection() {
    setCategorizationDetectorType(_aggregation_types.ML_JOB_AGGREGATION.RARE);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.pickFieldsStep.categorizationDetectorSelect.title",
    defaultMessage: "Categorization detector"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l",
    style: {
      maxWidth: '824px'
    }
  }, /*#__PURE__*/_react.default.createElement(_detector_cards.CountCard, {
    onClick: onCountSelection,
    isSelected: categorizationDetectorType === _aggregation_types.ML_JOB_AGGREGATION.COUNT
  }), /*#__PURE__*/_react.default.createElement(_detector_cards.RareCard, {
    onClick: onRareSelection,
    isSelected: categorizationDetectorType === _aggregation_types.ML_JOB_AGGREGATION.RARE
  })));
};
exports.CategorizationDetector = CategorizationDetector;