"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BucketSpanEstimator = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _job_creator = require("../../../../../common/job_creator");
var _job_creator_context = require("../../../job_creator_context");
var _field_types = require("../../../../../../../../../common/constants/field_types");
var _estimate_bucket_span = require("./estimate_bucket_span");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BucketSpanEstimator = ({
  setEstimating
}) => {
  const {
    jobCreator,
    jobCreatorUpdated
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const {
    status,
    estimateBucketSpan
  } = (0, _estimate_bucket_span.useEstimateBucketSpan)();
  const [noDetectors, setNoDetectors] = (0, _react.useState)(jobCreator.detectors.length === 0);
  const [isUsingMlCategory, setIsUsingMlCategory] = (0, _react.useState)(checkIsUsingMlCategory());
  (0, _react.useEffect)(() => {
    setEstimating(status === _estimate_bucket_span.ESTIMATE_STATUS.RUNNING);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [status]);
  (0, _react.useEffect)(() => {
    setNoDetectors(jobCreator.detectors.length === 0);
    setIsUsingMlCategory(checkIsUsingMlCategory());
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreatorUpdated]);
  function checkIsUsingMlCategory() {
    return (0, _job_creator.isAdvancedJobCreator)(jobCreator) && jobCreator.detectors.some(d => {
      if (d.partition_field_name === _field_types.MLCATEGORY || d.over_field_name === _field_types.MLCATEGORY || d.by_field_name === _field_types.MLCATEGORY) {
        return true;
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: status === _estimate_bucket_span.ESTIMATE_STATUS.RUNNING || noDetectors === true || isUsingMlCategory === true,
    onClick: estimateBucketSpan
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.pickFieldsStep.bucketSpanEstimatorButton",
    defaultMessage: "Estimate bucket span"
  }));
};
exports.BucketSpanEstimator = BucketSpanEstimator;