"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobDetailsStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _wizard_nav = require("../wizard_nav");
var _job_id = require("./components/job_id");
var _job_description = require("./components/job_description");
var _groups = require("./components/groups");
var _step_types = require("../step_types");
var _job_creator_context = require("../job_creator_context");
var _advanced_section = require("./components/advanced_section");
var _additional_section = require("./components/additional_section");
var _json_editor_flyout = require("../common/json_editor_flyout");
var _job_creator = require("../../../common/job_creator");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const JobDetailsStep = ({
  setCurrentStep,
  isCurrentStep,
  advancedExpanded,
  setAdvancedExpanded,
  additionalExpanded,
  setAdditionalExpanded
}) => {
  const {
    jobCreator,
    jobValidator,
    jobValidatorUpdated
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const [nextActive, setNextActive] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    var _jobValidator$latestV, _jobValidator$latestV2;
    const active = jobValidator.jobId.valid && jobValidator.modelMemoryLimit.valid && jobValidator.groupIds.valid && ((_jobValidator$latestV = jobValidator.latestValidationResult.jobIdExists) === null || _jobValidator$latestV === void 0 ? void 0 : _jobValidator$latestV.valid) === true && ((_jobValidator$latestV2 = jobValidator.latestValidationResult.groupIdsExist) === null || _jobValidator$latestV2 === void 0 ? void 0 : _jobValidator$latestV2.valid) === true && jobValidator.validating === false;
    setNextActive(active);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobValidatorUpdated]);
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, isCurrentStep && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xl"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_job_id.JobIdInput, null), /*#__PURE__*/_react.default.createElement(_groups.GroupsInput, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_job_description.JobDescriptionInput, null))), /*#__PURE__*/_react.default.createElement(_additional_section.AdditionalSection, {
    additionalExpanded: additionalExpanded,
    setAdditionalExpanded: setAdditionalExpanded
  }), /*#__PURE__*/_react.default.createElement(_advanced_section.AdvancedSection, {
    advancedExpanded: advancedExpanded,
    setAdvancedExpanded: setAdvancedExpanded
  }), /*#__PURE__*/_react.default.createElement(_wizard_nav.WizardNav, {
    previous: () => setCurrentStep(_step_types.WIZARD_STEPS.PICK_FIELDS),
    next: () => setCurrentStep(_step_types.WIZARD_STEPS.VALIDATION),
    nextActive: nextActive
  }, (0, _job_creator.isAdvancedJobCreator)(jobCreator) && /*#__PURE__*/_react.default.createElement(_json_editor_flyout.JsonEditorFlyout, {
    isDisabled: false,
    jobEditorMode: _json_editor_flyout.EDITOR_MODE.EDITABLE,
    datafeedEditorMode: _json_editor_flyout.EDITOR_MODE.EDITABLE
  }))));
};
exports.JobDetailsStep = JobDetailsStep;