"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedSection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _model_plot = require("./components/model_plot");
var _annotations = require("./components/annotations");
var _dedicated_index = require("./components/dedicated_index");
var _model_memory_limit = require("../../../common/model_memory_limit");
var _job_creator_context = require("../../../job_creator_context");
var _new_job = require("../../../../../../../../../common/constants/new_job");
var _ignore_unavailable = require("./components/ignore_unavailable");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buttonContent = _i18n.i18n.translate('xpack.ml.newJob.wizard.jobDetailsStep.advancedSectionButton', {
  defaultMessage: 'Advanced'
});
const AdvancedSection = ({
  advancedExpanded,
  setAdvancedExpanded
}) => {
  const {
    jobCreator
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  if (jobCreator.type === _new_job.JOB_TYPE.ADVANCED) {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "xl"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xl"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_model_plot.ModelPlotSwitch, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_dedicated_index.DedicatedIndexSwitch, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xl"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_annotations.AnnotationsSwitch, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_ignore_unavailable.IgnoreUnavailableSwitch, null))));
  }
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "advanced-section",
    buttonContent: buttonContent,
    onToggle: setAdvancedExpanded,
    initialIsOpen: advancedExpanded,
    "data-test-subj": "mlJobWizardToggleAdvancedSection"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xl",
    style: {
      marginLeft: '0px',
      marginRight: '0px'
    },
    "data-test-subj": "mlJobWizardAdvancedSection"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_model_plot.ModelPlotSwitch, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_dedicated_index.DedicatedIndexSwitch, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xl",
    style: {
      marginLeft: '0px',
      marginRight: '0px'
    },
    "data-test-subj": "mlJobWizardAdvancedSection"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_annotations.AnnotationsSwitch, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_ignore_unavailable.IgnoreUnavailableSwitch, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xl",
    style: {
      marginLeft: '0px',
      marginRight: '0px'
    },
    "data-test-subj": "mlJobWizardAdvancedSection"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_model_memory_limit.ModelMemoryLimitInput, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null))));
};
exports.AdvancedSection = AdvancedSection;