"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryDelayInput = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _job_creator_context = require("../../../job_creator_context");
var _description = require("./description");
var _hooks = require("../hooks");
var _new_job = require("../../../../../../../../../common/constants/new_job");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const QueryDelayInput = () => {
  const {
    jobCreator,
    jobCreatorUpdate,
    jobValidator,
    jobValidatorUpdated
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const [validation, setValidation] = (0, _react.useState)(jobValidator.queryDelay);
  const {
    value: queryDelay,
    setValue: setQueryDelay
  } = (0, _hooks.useStringifiedValue)(jobCreator.queryDelay);
  (0, _react.useEffect)(() => {
    jobCreator.queryDelay = queryDelay === '' ? null : queryDelay;
    jobCreatorUpdate();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [queryDelay]);
  (0, _react.useEffect)(() => {
    setQueryDelay(jobCreator.queryDelay === null ? '' : jobCreator.queryDelay);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreatorUpdate]);
  (0, _react.useEffect)(() => {
    setValidation(jobValidator.queryDelay);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobValidatorUpdated]);
  return /*#__PURE__*/_react.default.createElement(_description.Description, {
    validation: validation
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: queryDelay,
    placeholder: _new_job.DEFAULT_QUERY_DELAY,
    onChange: e => setQueryDelay(e.target.value),
    isInvalid: validation.valid === false,
    "data-test-subj": "mlJobWizardInputQueryDelay"
  }));
};
exports.QueryDelayInput = QueryDelayInput;