"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditCategorizationAnalyzerFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _ml_job_editor = require("../../../../../jobs_list/components/ml_job_editor");
var _validation_utils = require("../../../../../../../../common/util/validation_utils");
var _job_creator_context = require("../../job_creator_context");
var _ml_server_info = require("../../../../../../services/ml_server_info");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EDITOR_HEIGHT = '800px';
const EditCategorizationAnalyzerFlyout = () => {
  const {
    jobCreator: jc,
    jobCreatorUpdate
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const jobCreator = jc;
  const [showJsonFlyout, setShowJsonFlyout] = (0, _react.useState)(false);
  const [saveable, setSaveable] = (0, _react.useState)(false);
  const [categorizationAnalyzerString, setCategorizationAnalyzerString] = (0, _react.useState)(JSON.stringify(jobCreator.categorizationAnalyzer, null, 2));
  (0, _react.useEffect)(() => {
    if (showJsonFlyout === true) {
      setCategorizationAnalyzerString(JSON.stringify(jobCreator.categorizationAnalyzer, null, 2));
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [showJsonFlyout]);
  function toggleJsonFlyout() {
    setSaveable(false);
    setShowJsonFlyout(!showJsonFlyout);
  }
  function onJSONChange(json) {
    setCategorizationAnalyzerString(json);
    const valid = (0, _validation_utils.isValidJson)(json);
    setSaveable(valid);
  }
  function onSave() {
    jobCreator.categorizationAnalyzer = JSON.parse(categorizationAnalyzerString);
    jobCreatorUpdate();
    setShowJsonFlyout(false);
  }
  function onUseDefault() {
    const {
      anomaly_detectors: anomalyDetectors
    } = (0, _ml_server_info.getNewJobDefaults)();
    const analyzerString = JSON.stringify(anomalyDetectors.categorization_analyzer, null, 2);
    onJSONChange(analyzerString);
  }
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(FlyoutButton, {
    onClick: toggleJsonFlyout
  }), showJsonFlyout === true && /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: () => setShowJsonFlyout(false),
    hideCloseButton: true,
    size: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(Contents, {
    onChange: onJSONChange,
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.categorizationAnalyzerFlyout.title', {
      defaultMessage: 'Edit categorization analyzer JSON'
    }),
    value: categorizationAnalyzerString
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: () => setShowJsonFlyout(false),
    flush: "left"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.categorizationAnalyzerFlyout.closeButton",
    defaultMessage: "Close"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onUseDefault
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.categorizationAnalyzerFlyout.useDefaultButton",
    defaultMessage: "Use default ML analyzer"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: onSave,
    fill: true,
    isDisabled: saveable === false
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.categorizationAnalyzerFlyout.saveButton",
    defaultMessage: "Save"
  })))))));
};
exports.EditCategorizationAnalyzerFlyout = EditCategorizationAnalyzerFlyout;
const FlyoutButton = ({
  onClick
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClick,
    flush: "left",
    "data-test-subj": "mlJobWizardButtonPreviewJobJson"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.editCategorizationAnalyzerFlyoutButton",
    defaultMessage: "Edit categorization analyzer"
  }));
};
const Contents = ({
  title,
  value,
  onChange
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h5", null, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_ml_job_editor.MLJobEditor, {
    value: value,
    height: EDITOR_HEIGHT,
    readOnly: false,
    onChange: onChange
  }));
};