"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventRateChart = void 0;
var _react = _interopRequireDefault(require("react"));
var _charts = require("@elastic/charts");
var _react2 = require("@emotion/react");
var _axes = require("../common/axes");
var _settings = require("../common/settings");
var _loading_wrapper = require("../loading_wrapper");
var _anomalies = require("../common/anomalies");
var _overlay_range = require("./overlay_range");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EventRateChart = ({
  eventRateChartData,
  anomalyData,
  height,
  width,
  showAxis,
  loading = false,
  fadeChart,
  overlayRanges,
  onBrushEnd
}) => {
  const {
    EVENT_RATE_COLOR_WITH_ANOMALIES,
    EVENT_RATE_COLOR
  } = (0, _settings.useChartColors)();
  const barColor = fadeChart ? EVENT_RATE_COLOR_WITH_ANOMALIES : EVENT_RATE_COLOR;
  const theme = {
    scales: {
      histogramPadding: 0.2
    }
  };
  const cssOverride = (0, _react2.css)({
    // fix for the annotation label being hidden inside the bounds of the chart container
    '.echContainer': {
      overflow: 'visible'
    }
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width,
      height
    },
    "data-test-subj": `mlEventRateChart ${eventRateChartData.length ? 'withData' : 'empty'}`
  }, /*#__PURE__*/_react.default.createElement(_loading_wrapper.LoadingWrapper, {
    height: height,
    hasData: eventRateChartData.length > 0,
    loading: loading
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    css: overlayRanges !== undefined ? cssOverride : undefined
  }, showAxis === true && /*#__PURE__*/_react.default.createElement(_axes.Axes, null), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    tooltip: _charts.TooltipType.None,
    onBrushEnd: onBrushEnd
    // TODO use the EUI charts theme see src/plugins/charts/public/services/theme/README.md
    ,
    theme: theme
  }), overlayRanges && overlayRanges.map((range, i) => /*#__PURE__*/_react.default.createElement(_overlay_range.OverlayRange, {
    key: i,
    overlayKey: i,
    start: range.start,
    end: range.end,
    color: range.color,
    showMarker: range.showMarker
  })), /*#__PURE__*/_react.default.createElement(_anomalies.Anomalies, {
    anomalyData: anomalyData
  }), /*#__PURE__*/_react.default.createElement(_charts.HistogramBarSeries, {
    id: "event_rate",
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: 'time',
    yAccessors: ['value'],
    data: eventRateChartData,
    color: barColor
  }))));
};
exports.EventRateChart = EventRateChart;