"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Anomalies = void 0;
var _react = _interopRequireWildcard(require("react"));
var _charts = require("@elastic/charts");
var _anomaly_utils = require("../../../../../../../../common/util/anomaly_utils");
var _anomalies = require("../../../../../../../../common/constants/anomalies");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getAnomalyStyle(threshold) {
  return {
    line: {
      stroke: (0, _anomaly_utils.getSeverityColor)(threshold),
      strokeWidth: 3,
      opacity: 1
    }
  };
}
function splitAnomalySeverities(anomalies) {
  const severities = {
    critical: [],
    major: [],
    minor: [],
    warning: [],
    unknown: [],
    low: []
  };
  anomalies.forEach(a => {
    if (a.value !== 0) {
      severities[a.severity].push({
        dataValue: a.time
      });
    }
  });
  return severities;
}
const Anomalies = ({
  anomalyData
}) => {
  const anomalies = anomalyData === undefined ? [] : anomalyData;
  const severities = splitAnomalySeverities(anomalies);
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
    id: "low",
    domainType: _charts.AnnotationDomainType.XDomain,
    dataValues: severities.low,
    style: getAnomalyStyle(_anomalies.ANOMALY_THRESHOLD.LOW),
    hideTooltips: true
  }), /*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
    id: "warning",
    domainType: _charts.AnnotationDomainType.XDomain,
    dataValues: severities.warning,
    style: getAnomalyStyle(_anomalies.ANOMALY_THRESHOLD.WARNING),
    hideTooltips: true
  }), /*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
    id: "minor",
    domainType: _charts.AnnotationDomainType.XDomain,
    dataValues: severities.minor,
    style: getAnomalyStyle(_anomalies.ANOMALY_THRESHOLD.MINOR),
    hideTooltips: true
  }), /*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
    id: "major",
    domainType: _charts.AnnotationDomainType.XDomain,
    dataValues: severities.major,
    style: getAnomalyStyle(_anomalies.ANOMALY_THRESHOLD.MAJOR),
    hideTooltips: true
  }), /*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
    id: "critical",
    domainType: _charts.AnnotationDomainType.XDomain,
    dataValues: severities.critical,
    style: getAnomalyStyle(_anomalies.ANOMALY_THRESHOLD.CRITICAL),
    hideTooltips: true
  }));
};
exports.Anomalies = Anomalies;