"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resolver = resolver;
var _rison = _interopRequireDefault(require("@kbn/rison"));
var _quick_create_job = require("./quick_create_job");
var _ml_api_service = require("../../../services/ml_api_service");
var _dependency_cache = require("../../../util/dependency_cache");
var _new_job_utils = require("../utils/new_job_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function resolver(dashboard, dataViewId, embeddable, geoField, splitField, fromRisonString, toRisonString, layer) {
  var _decodedLayer;
  let decodedDashboard;
  let decodedEmbeddable;
  let decodedLayer;
  let splitFieldDecoded;
  let dvId;
  try {
    dvId = _rison.default.decode(dataViewId);
  } catch (error) {
    dvId = '';
  }
  try {
    decodedDashboard = _rison.default.decode(dashboard);
  } catch (error) {
    decodedDashboard = {
      query: (0, _new_job_utils.getDefaultQuery)(),
      filters: []
    };
  }
  try {
    decodedEmbeddable = _rison.default.decode(embeddable);
  } catch (error) {
    decodedEmbeddable = {
      query: (0, _new_job_utils.getDefaultQuery)(),
      filters: []
    };
  }
  if (layer) {
    try {
      decodedLayer = _rison.default.decode(layer);
    } catch (error) {
      decodedLayer = {
        query: (0, _new_job_utils.getDefaultQuery)(),
        filters: []
      };
    }
  }
  try {
    splitFieldDecoded = _rison.default.decode(splitField);
  } catch (error) {
    splitFieldDecoded = null;
  }
  let from;
  let to;
  try {
    from = _rison.default.decode(fromRisonString);
  } catch (error) {
    from = '';
  }
  try {
    to = _rison.default.decode(toRisonString);
  } catch (error) {
    to = '';
  }
  const jobCreator = new _quick_create_job.QuickGeoJobCreator((0, _dependency_cache.getUiSettings)(), (0, _dependency_cache.getTimefilter)(), (0, _dependency_cache.getShare)(), _ml_api_service.ml);
  await jobCreator.createAndStashGeoJob(dvId, from, to, decodedDashboard.query, decodedDashboard.filters, decodedEmbeddable.query, decodedEmbeddable.filters, geoField, splitFieldDecoded, (_decodedLayer = decodedLayer) === null || _decodedLayer === void 0 ? void 0 : _decodedLayer.query);
}