"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resolver = resolver;
var _rison = _interopRequireDefault(require("@kbn/rison"));
var _quick_create_job = require("./quick_create_job");
var _ml_api_service = require("../../../services/ml_api_service");
var _dependency_cache = require("../../../util/dependency_cache");
var _new_job_utils = require("../utils/new_job_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function resolver(lensSavedObjectId, lensSavedObjectRisonString, fromRisonStrong, toRisonStrong, queryRisonString, filtersRisonString, layerIndexRisonString) {
  let vis;
  if (lensSavedObjectId) {
    vis = await getLensSavedObject(lensSavedObjectId);
  } else if (lensSavedObjectRisonString) {
    vis = _rison.default.decode(lensSavedObjectRisonString);
  } else {
    throw new Error('Cannot create visualization');
  }
  let query;
  let filters;
  try {
    query = _rison.default.decode(queryRisonString);
  } catch (error) {
    query = (0, _new_job_utils.getDefaultQuery)();
  }
  try {
    filters = _rison.default.decode(filtersRisonString);
  } catch (error) {
    filters = [];
  }
  let from;
  let to;
  try {
    from = _rison.default.decode(fromRisonStrong);
  } catch (error) {
    from = '';
  }
  try {
    to = _rison.default.decode(toRisonStrong);
  } catch (error) {
    to = '';
  }
  let layerIndex;
  try {
    layerIndex = _rison.default.decode(layerIndexRisonString);
  } catch (error) {
    layerIndex = undefined;
  }
  const jobCreator = new _quick_create_job.QuickLensJobCreator((0, _dependency_cache.getLens)(), (0, _dependency_cache.getUiSettings)(), (0, _dependency_cache.getTimefilter)(), (0, _dependency_cache.getShare)(), _ml_api_service.ml);
  await jobCreator.createAndStashADJob(vis, from, to, query, filters, layerIndex);
}
async function getLensSavedObject(id) {
  const savedObjectClient = (0, _dependency_cache.getSavedObjectsClient)();
  const so = await savedObjectClient.get('lens', id);
  return so.attributes;
}