"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.advancedStartDatafeed = advancedStartDatafeed;
exports.aggFieldPairsCanBeCharted = aggFieldPairsCanBeCharted;
exports.collectAggs = collectAggs;
exports.convertToAdvancedJob = convertToAdvancedJob;
exports.convertToMultiMetricJob = convertToMultiMetricJob;
exports.createDocCountFieldOption = createDocCountFieldOption;
exports.createFieldOptions = createFieldOptions;
exports.createMlcategoryFieldOption = createMlcategoryFieldOption;
exports.getJobCreatorTitle = getJobCreatorTitle;
exports.getRichDetectors = getRichDetectors;
exports.isSparseDataJob = isSparseDataJob;
exports.resetAdvancedJob = resetAdvancedJob;
exports.resetJob = resetJob;
exports.stashJobForCloning = stashJobForCloning;
var _i18n = require("@kbn/i18n");
var _fieldTypes = require("@kbn/field-types");
var _new_job_capabilities_service = require("../../../../../services/new_job_capabilities/new_job_capabilities_service");
var _aggregation_types = require("../../../../../../../common/constants/aggregation_types");
var _field_types = require("../../../../../../../common/constants/field_types");
var _locator = require("../../../../../../../common/constants/locator");
var _fields = require("../../../../../../../common/types/fields");
var _job_service = require("../../../../../services/job_service");
var _new_job = require("../../../../../../../common/constants/new_job");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFieldByIdFactory = additionalFields => id => {
  let field = _new_job_capabilities_service.newJobCapsService.getFieldById(id);
  // if no field could be found it may be a pretend field, like mlcategory or a script field
  if (field === null) {
    if (id === _field_types.MLCATEGORY) {
      field = _fields.mlCategory;
    } else if (additionalFields.length) {
      field = additionalFields.find(f => f.id === id) || null;
    }
  }
  return field;
};

// populate the detectors with Field and Agg objects loaded from the job capabilities service
function getRichDetectors(job, datafeed, additionalFields, advanced = false) {
  const detectors = advanced ? getDetectorsAdvanced(job, datafeed) : getDetectors(job, datafeed);
  const getFieldById = getFieldByIdFactory(additionalFields);
  return detectors.map(d => {
    var _d$exclude_frequent, _d$detector_descripti, _d$use_null;
    let field = null;
    let byField = null;
    let overField = null;
    let partitionField = null;
    if (d.field_name !== undefined) {
      field = getFieldById(d.field_name);
    }
    if (d.by_field_name !== undefined) {
      byField = getFieldById(d.by_field_name);
    }
    if (d.over_field_name !== undefined) {
      overField = getFieldById(d.over_field_name);
    }
    if (d.partition_field_name !== undefined) {
      partitionField = getFieldById(d.partition_field_name);
    }
    return {
      agg: _new_job_capabilities_service.newJobCapsService.getAggById(d.function),
      field,
      byField,
      overField,
      partitionField,
      excludeFrequent: (_d$exclude_frequent = d.exclude_frequent) !== null && _d$exclude_frequent !== void 0 ? _d$exclude_frequent : null,
      description: (_d$detector_descripti = d.detector_description) !== null && _d$detector_descripti !== void 0 ? _d$detector_descripti : null,
      useNull: (_d$use_null = d.use_null) !== null && _d$use_null !== void 0 ? _d$use_null : null
    };
  });
}
function createFieldOptions(fields, additionalFields) {
  return [...fields.filter(f => f.id !== _fields.EVENT_RATE_FIELD_ID).map(f => ({
    label: f.name,
    field: f
  })), ...additionalFields.filter(f => fields.some(f2 => f2.id === f.id) === false).map(f => ({
    label: f.id,
    field: f
  }))].sort((a, b) => a.label.localeCompare(b.label));
}
function createMlcategoryFieldOption(categorizationFieldName) {
  if (categorizationFieldName === null) {
    return [];
  }
  return [{
    label: _field_types.MLCATEGORY
  }];
}
function createDocCountFieldOption(usingAggregations) {
  return usingAggregations ? [{
    label: _field_types.DOC_COUNT
  }] : [{
    label: _field_types._DOC_COUNT
  }];
}
function getDetectorsAdvanced(job, datafeed) {
  return processFieldlessAggs(job.analysis_config.detectors);
}
function getDetectors(job, datafeed) {
  let detectors = job.analysis_config.detectors;
  const sparseData = isSparseDataJob(job, datafeed);

  // if aggregations have been used in a single metric job and a distinct count detector
  // was used, we need to rebuild the detector.
  if (datafeed.aggregations !== undefined && job.analysis_config.detectors[0].function === _aggregation_types.ML_JOB_AGGREGATION.NON_ZERO_COUNT && sparseData === false) {
    var _datafeed$aggregation, _datafeed$aggregation2, _datafeed$aggregation3, _datafeed$aggregation4, _datafeed$aggregation5;
    // distinct count detector, field has been removed.
    // determine field from datafeed aggregations
    const field = datafeed === null || datafeed === void 0 ? void 0 : (_datafeed$aggregation = datafeed.aggregations) === null || _datafeed$aggregation === void 0 ? void 0 : (_datafeed$aggregation2 = _datafeed$aggregation.buckets) === null || _datafeed$aggregation2 === void 0 ? void 0 : (_datafeed$aggregation3 = _datafeed$aggregation2.aggregations) === null || _datafeed$aggregation3 === void 0 ? void 0 : (_datafeed$aggregation4 = _datafeed$aggregation3.dc_region) === null || _datafeed$aggregation4 === void 0 ? void 0 : (_datafeed$aggregation5 = _datafeed$aggregation4.cardinality) === null || _datafeed$aggregation5 === void 0 ? void 0 : _datafeed$aggregation5.field;
    if (field !== undefined) {
      detectors = [{
        function: _aggregation_types.ML_JOB_AGGREGATION.DISTINCT_COUNT,
        field_name: field
      }];
    }
  } else {
    // all other detectors.
    detectors = processFieldlessAggs(detectors);
    detectors = detectors.map(d => {
      switch (d.function) {
        // if sparse data functions were used, replace them with their non-sparse versions
        // the sparse data flag has already been determined and set, so this information is not being lost.
        case _aggregation_types.ML_JOB_AGGREGATION.NON_ZERO_COUNT:
          return {
            ...d,
            field_name: _fields.EVENT_RATE_FIELD_ID,
            function: _aggregation_types.ML_JOB_AGGREGATION.COUNT
          };
        case _aggregation_types.ML_JOB_AGGREGATION.HIGH_NON_ZERO_COUNT:
          return {
            ...d,
            field_name: _fields.EVENT_RATE_FIELD_ID,
            function: _aggregation_types.ML_JOB_AGGREGATION.HIGH_COUNT
          };
        case _aggregation_types.ML_JOB_AGGREGATION.LOW_NON_ZERO_COUNT:
          return {
            ...d,
            field_name: _fields.EVENT_RATE_FIELD_ID,
            function: _aggregation_types.ML_JOB_AGGREGATION.LOW_COUNT
          };
        case _aggregation_types.ML_JOB_AGGREGATION.NON_NULL_SUM:
          return {
            ...d,
            function: _aggregation_types.ML_JOB_AGGREGATION.SUM
          };
        case _aggregation_types.ML_JOB_AGGREGATION.HIGH_NON_NULL_SUM:
          return {
            ...d,
            function: _aggregation_types.ML_JOB_AGGREGATION.HIGH_SUM
          };
        case _aggregation_types.ML_JOB_AGGREGATION.LOW_NON_NULL_SUM:
          return {
            ...d,
            function: _aggregation_types.ML_JOB_AGGREGATION.LOW_SUM
          };
        default:
          return d;
      }
    });
  }
  return detectors;
}

// if a fieldless function is used, add EVENT_RATE_FIELD_ID as its field
function processFieldlessAggs(detectors) {
  return detectors.map(d => {
    switch (d.function) {
      case _aggregation_types.ML_JOB_AGGREGATION.COUNT:
      case _aggregation_types.ML_JOB_AGGREGATION.HIGH_COUNT:
      case _aggregation_types.ML_JOB_AGGREGATION.LOW_COUNT:
      case _aggregation_types.ML_JOB_AGGREGATION.NON_ZERO_COUNT:
      case _aggregation_types.ML_JOB_AGGREGATION.HIGH_NON_ZERO_COUNT:
      case _aggregation_types.ML_JOB_AGGREGATION.LOW_NON_ZERO_COUNT:
      case _aggregation_types.ML_JOB_AGGREGATION.RARE:
      case _aggregation_types.ML_JOB_AGGREGATION.FREQ_RARE:
      case _aggregation_types.ML_JOB_AGGREGATION.TIME_OF_DAY:
      case _aggregation_types.ML_JOB_AGGREGATION.TIME_OF_WEEK:
        return {
          ...d,
          field_name: _fields.EVENT_RATE_FIELD_ID
        };
      default:
        return d;
    }
  });
}

// determine whether the job has been configured to run on sparse data
// by looking to see whether the datafeed contains a dc_region field in an aggregation
// if it does, it is a distinct count single metric job and no a sparse data job.
// this check is needed because distinct count jobs also use NON_ZERO_COUNT
function isSparseDataJob(job, datafeed) {
  var _datafeed$aggregation6, _datafeed$aggregation7, _datafeed$aggregation8, _datafeed$aggregation9, _datafeed$aggregation10;
  const detectors = job.analysis_config.detectors;
  const distinctCountField = datafeed === null || datafeed === void 0 ? void 0 : (_datafeed$aggregation6 = datafeed.aggregations) === null || _datafeed$aggregation6 === void 0 ? void 0 : (_datafeed$aggregation7 = _datafeed$aggregation6.buckets) === null || _datafeed$aggregation7 === void 0 ? void 0 : (_datafeed$aggregation8 = _datafeed$aggregation7.aggregations) === null || _datafeed$aggregation8 === void 0 ? void 0 : (_datafeed$aggregation9 = _datafeed$aggregation8.dc_region) === null || _datafeed$aggregation9 === void 0 ? void 0 : (_datafeed$aggregation10 = _datafeed$aggregation9.cardinality) === null || _datafeed$aggregation10 === void 0 ? void 0 : _datafeed$aggregation10.field;

  // if distinctCountField is undefined, and any detectors contain a sparse data function
  // return true
  if (distinctCountField === undefined) {
    for (const detector of detectors) {
      if (_aggregation_types.SPARSE_DATA_AGGREGATIONS.includes(detector.function)) {
        return true;
      }
    }
  }
  return false;
}
function stashJobForCloning(jobCreator, skipTimeRangeStep = false, includeTimeRange = false, autoSetTimeRange = false) {
  var _jobCreator$createdBy;
  _job_service.mlJobService.tempJobCloningObjects.job = jobCreator.jobConfig;
  _job_service.mlJobService.tempJobCloningObjects.datafeed = jobCreator.datafeedConfig;
  _job_service.mlJobService.tempJobCloningObjects.createdBy = (_jobCreator$createdBy = jobCreator.createdBy) !== null && _jobCreator$createdBy !== void 0 ? _jobCreator$createdBy : undefined;

  // skip over the time picker step of the wizard
  _job_service.mlJobService.tempJobCloningObjects.skipTimeRangeStep = skipTimeRangeStep;
  if (includeTimeRange === true && autoSetTimeRange === false) {
    // auto select the start and end dates of the time picker
    _job_service.mlJobService.tempJobCloningObjects.start = jobCreator.start;
    _job_service.mlJobService.tempJobCloningObjects.end = jobCreator.end;
  } else if (autoSetTimeRange === true) {
    _job_service.mlJobService.tempJobCloningObjects.autoSetTimeRange = true;
  }
  _job_service.mlJobService.tempJobCloningObjects.calendars = jobCreator.calendars;
}
function convertToMultiMetricJob(jobCreator, navigateToPath) {
  jobCreator.createdBy = _new_job.CREATED_BY_LABEL.MULTI_METRIC;
  jobCreator.modelPlot = false;
  stashJobForCloning(jobCreator, true, true);
  navigateToPath(_locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_CONVERT_TO_MULTI_METRIC, true);
}
function convertToAdvancedJob(jobCreator, navigateToPath) {
  jobCreator.createdBy = null;
  stashJobForCloning(jobCreator, true, true);
  navigateToPath(_locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_CONVERT_TO_ADVANCED, true);
}
function resetAdvancedJob(jobCreator, navigateToPath) {
  jobCreator.createdBy = null;
  stashJobForCloning(jobCreator, true, false);
  navigateToPath(_locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB);
}
function resetJob(jobCreator, navigateToPath) {
  jobCreator.jobId = '';
  stashJobForCloning(jobCreator, true, true);
  navigateToPath(_locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB);
}
function advancedStartDatafeed(jobCreator, navigateToPath) {
  if (jobCreator !== null) {
    stashJobForCloning(jobCreator, false, false);
  }
  navigateToPath('/jobs');
}
function aggFieldPairsCanBeCharted(afs) {
  return afs.some(a => a.agg.dslName === null) === false;
}
function getJobCreatorTitle(jobCreator) {
  switch (jobCreator.type) {
    case _new_job.JOB_TYPE.SINGLE_METRIC:
      return _i18n.i18n.translate('xpack.ml.newJob.wizard.jobCreatorTitle.singleMetric', {
        defaultMessage: 'Single metric'
      });
    case _new_job.JOB_TYPE.MULTI_METRIC:
      return _i18n.i18n.translate('xpack.ml.newJob.wizard.jobCreatorTitle.multiMetric', {
        defaultMessage: 'Multi-metric'
      });
    case _new_job.JOB_TYPE.POPULATION:
      return _i18n.i18n.translate('xpack.ml.newJob.wizard.jobCreatorTitle.population', {
        defaultMessage: 'Population'
      });
    case _new_job.JOB_TYPE.ADVANCED:
      return _i18n.i18n.translate('xpack.ml.newJob.wizard.jobCreatorTitle.advanced', {
        defaultMessage: 'Advanced'
      });
    case _new_job.JOB_TYPE.CATEGORIZATION:
      return _i18n.i18n.translate('xpack.ml.newJob.wizard.jobCreatorTitle.categorization', {
        defaultMessage: 'Categorization'
      });
    case _new_job.JOB_TYPE.RARE:
      return _i18n.i18n.translate('xpack.ml.newJob.wizard.jobCreatorTitle.rare', {
        defaultMessage: 'Rare'
      });
    case _new_job.JOB_TYPE.GEO:
      return _i18n.i18n.translate('xpack.ml.newJob.wizard.jobCreatorTitle.geo', {
        defaultMessage: 'Geo'
      });
    default:
      return '';
  }
}

// recurse through a datafeed aggregation object,
// adding top level keys from each nested agg to an array
// of fields
function collectAggs(o, aggFields) {
  for (const i in o) {
    if (o[i] !== null && typeof o[i] === 'object') {
      if (i === 'aggregations' || i === 'aggs') {
        Object.keys(o[i]).forEach(k => {
          if (k !== 'aggregations' && k !== 'aggs') {
            aggFields.push({
              id: k,
              name: k,
              type: _fieldTypes.ES_FIELD_TYPES.KEYWORD,
              aggregatable: true,
              counter: false
            });
          }
        });
      }
      collectAggs(o[i], aggFields);
    }
  }
}