"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeRangePicker = void 0;
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _ml = require("../../../../contexts/ml");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WIDTH = '512px';
const TimeRangePicker = ({
  setTimeRange,
  timeRange
}) => {
  const mlContext = (0, _ml.useMlContext)();
  const dateFormat = mlContext.kibanaConfig.get('dateFormat');
  const [startMoment, setStartMoment] = (0, _react.useState)((0, _moment.default)(timeRange.start));
  const [endMoment, setEndMoment] = (0, _react.useState)((0, _moment.default)(timeRange.end));
  function handleChangeStart(date) {
    setStartMoment(date || undefined);
  }
  function handleChangeEnd(date) {
    setEndMoment(date || undefined);
  }

  // update the parent start and end if the timepicker changes
  (0, _react.useEffect)(() => {
    if (startMoment !== undefined && endMoment !== undefined) {
      setTimeRange({
        start: startMoment.valueOf(),
        end: endMoment.valueOf()
      });
    }
  }, [startMoment, endMoment, setTimeRange]);

  // update our local start and end moment objects if
  // the parent start and end updates.
  // this happens if the use full data button is pressed.
  (0, _react.useEffect)(() => {
    setStartMoment((0, _moment.default)(timeRange.start));
    setEndMoment((0, _moment.default)(timeRange.end));
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [JSON.stringify(timeRange)]);
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      minWidth: WIDTH
    },
    "data-test-subj": `mlJobWizardDateRange`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDatePickerRange, {
    fullWidth: true,
    startDateControl: /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, {
      selected: startMoment,
      onChange: handleChangeStart,
      startDate: startMoment,
      endDate: endMoment,
      "aria-label": _i18n.i18n.translate('xpack.ml.newJob.wizard.timeRangeStep.timeRangePicker.startDateLabel', {
        defaultMessage: 'Start date'
      }),
      showTimeSelect: true,
      dateFormat: dateFormat,
      maxDate: endMoment
    }),
    endDateControl: /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, {
      selected: endMoment,
      onChange: handleChangeEnd,
      startDate: startMoment,
      endDate: endMoment,
      "aria-label": _i18n.i18n.translate('xpack.ml.newJob.wizard.timeRangeStep.timeRangePicker.endDateLabel', {
        defaultMessage: 'End date'
      }),
      showTimeSelect: true,
      dateFormat: dateFormat,
      minDate: startMoment
    })
  })));
};
exports.TimeRangePicker = TimeRangePicker;