"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewJobButton = NewJobButton;
var _check_capabilities = require("../../../../capabilities/check_capabilities");
var _check_ml_nodes = require("../../../../ml_nodes_check/check_ml_nodes");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_create_url = require("../../../../contexts/kibana/use_create_url");
var _locator = require("../../../../../../common/constants/locator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function NewJobButton() {
  const buttonEnabled = (0, _check_capabilities.checkPermission)('canCreateJob') && (0, _check_ml_nodes.mlNodesAvailable)();
  const newJob = (0, _use_create_url.useCreateAndNavigateToMlLink)(_locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_SELECT_INDEX);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "mlCreateNewJobButton",
    onClick: newJob,
    size: "s",
    disabled: buttonEnabled === false,
    fill: true,
    iconType: "plusInCircle"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.jobsList.createNewJobButtonLabel",
    defaultMessage: "Create job"
  }));
}