"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultiJobActions = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _job_actions = require("../job_actions");
var _actions_menu = require("./actions_menu");
var _group_selector = require("./group_selector");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const cssOverride = (0, _react2.css)({
  height: '20px',
  width: '1px',
  display: 'inline-block',
  verticalAlign: 'middle',
  margin: '0 5px'
});
class MultiJobActions extends _react.Component {
  constructor(props) {
    super(props);
    this.state = {};
  }
  render() {
    const jobsSelected = this.props.selectedJobs.length > 0;
    return /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": `mlADJobListMultiSelectActionsArea ${jobsSelected ? 'active' : 'inactive'}`
    }, jobsSelected ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      alignItems: "center",
      wrap: false,
      direction: "row",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.multiJobsActions.jobsSelectedLabel",
      defaultMessage: "{selectedJobsCount, plural, one {# job} other {# jobs}}   selected",
      values: {
        selectedJobsCount: this.props.selectedJobs.length
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement("div", {
      css: cssOverride
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_job_actions.ResultLinks, {
      jobs: this.props.selectedJobs
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_group_selector.GroupSelector, {
      jobs: this.props.selectedJobs,
      allJobIds: this.props.allJobIds,
      refreshJobs: this.props.refreshJobs
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_actions_menu.MultiJobActionsMenu, {
      jobs: this.props.selectedJobs,
      showCloseJobsConfirmModal: this.props.showCloseJobsConfirmModal,
      showStartDatafeedModal: this.props.showStartDatafeedModal,
      showDeleteJobModal: this.props.showDeleteJobModal,
      showResetJobModal: this.props.showResetJobModal,
      showStopDatafeedsConfirmModal: this.props.showStopDatafeedsConfirmModal,
      refreshJobs: this.props.refreshJobs,
      showCreateAlertFlyout: this.props.showCreateAlertFlyout
    }))) : null);
  }
}
exports.MultiJobActions = MultiJobActions;
MultiJobActions.propTypes = {
  selectedJobs: _propTypes.default.array.isRequired,
  allJobIds: _propTypes.default.array.isRequired,
  showStartDatafeedModal: _propTypes.default.func.isRequired,
  showCloseJobsConfirmModal: _propTypes.default.func.isRequired,
  showDeleteJobModal: _propTypes.default.func.isRequired,
  showResetJobModal: _propTypes.default.func.isRequired,
  showStopDatafeedsConfirmModal: _propTypes.default.func.isRequired,
  refreshJobs: _propTypes.default.func.isRequired,
  showCreateAlertFlyout: _propTypes.default.func.isRequired
};