"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobMessagesPane = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlErrorUtils = require("@kbn/ml-error-utils");
var _ml_api_service = require("../../../../services/ml_api_service");
var _job_messages = require("../../../../components/job_messages");
var _toast_notification_service = require("../../../../services/toast_notification_service");
var _kibana = require("../../../../contexts/kibana");
var _check_capabilities = require("../../../../capabilities/check_capabilities");
var _component_utils = require("../../../../util/component_utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const JobMessagesPane = /*#__PURE__*/_react.default.memo(({
  jobId,
  start,
  end,
  actionHandler,
  refreshJobList,
  showClearButton
}) => {
  const canCreateJob = (0, _check_capabilities.checkPermission)('canCreateJob');
  const [messages, setMessages] = (0, _react.useState)([]);
  const [notificationIndices, setNotificationIndices] = (0, _react.useState)([]);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [errorMessage, setErrorMessage] = (0, _react.useState)('');
  const [isClearing, setIsClearing] = (0, _react.useState)(false);
  const toastNotificationService = (0, _toast_notification_service.useToastNotificationService)();
  const {
    jobs: {
      clearJobAuditMessages
    }
  } = (0, _kibana.useMlApiContext)();
  const fetchMessages = async () => {
    setIsLoading(true);
    try {
      const messagesResp = await _ml_api_service.ml.jobs.jobAuditMessages({
        jobId,
        start,
        end
      });
      setMessages(messagesResp.messages);
      setNotificationIndices(messagesResp.notificationIndices);
      setIsLoading(false);
    } catch (error) {
      setIsLoading(false);
      toastNotificationService.displayErrorToast(error, _i18n.i18n.translate('xpack.ml.jobService.jobAuditMessagesErrorTitle', {
        defaultMessage: 'Error loading job messages'
      }));
      setErrorMessage((0, _mlErrorUtils.extractErrorMessage)(error));
    }
  };

  // eslint-disable-next-line react-hooks/exhaustive-deps
  const refreshMessage = (0, _react.useCallback)(fetchMessages, [jobId]);

  // Clear messages for last 24hrs and refresh jobs list
  const clearMessages = (0, _react.useCallback)(async () => {
    setIsClearing(true);
    try {
      await clearJobAuditMessages(jobId, notificationIndices);
      setIsClearing(false);
      if (typeof refreshJobList === 'function') {
        refreshJobList();
      }
    } catch (e) {
      setIsClearing(false);
      toastNotificationService.displayErrorToast(e, _i18n.i18n.translate('xpack.ml.jobMessages.clearJobAuditMessagesErrorTitle', {
        defaultMessage: 'Error clearing job message warnings and errors'
      }));
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobId, JSON.stringify(notificationIndices)]);
  (0, _react.useEffect)(() => {
    fetchMessages();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const disabled = notificationIndices.length === 0;
  const clearButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    isLoading: isClearing,
    isDisabled: disabled,
    onClick: (0, _component_utils.blurButtonOnClick)(() => {
      clearMessages();
    }),
    "data-test-subj": "mlJobMessagesClearButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.jobMessages.clearMessagesLabel",
    defaultMessage: "Clear notifications"
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, canCreateJob && showClearButton ? /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, canCreateJob && showClearButton ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", null, disabled === true ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.ml.jobMessages.clearJobAuditMessagesDisabledTooltip', {
      defaultMessage: 'Notification clearing not supported.'
    })
  }, clearButton) : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.ml.jobMessages.clearJobAuditMessagesTooltip', {
      defaultMessage: 'Clears warning icon from jobs list for messages produced in the last 24 hours.'
    })
  }, clearButton))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_job_messages.JobMessages, {
    refreshMessage: refreshMessage,
    messages: messages,
    loading: isLoading,
    error: errorMessage,
    actionHandler: actionHandler
  }))));
});
exports.JobMessagesPane = JobMessagesPane;