"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobDetails = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _ml_api_service = require("../../../../../services/ml_api_service");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _group_color_utils = require("../../../../../../../common/util/group_color_utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class JobDetails extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "onDescriptionChange", e => {
      this.setJobDetails({
        jobDescription: e.target.value
      });
    });
    (0, _defineProperty2.default)(this, "onMmlChange", e => {
      this.setJobDetails({
        jobModelMemoryLimit: e.target.value
      });
    });
    (0, _defineProperty2.default)(this, "onModelSnapshotRetentionDaysChange", e => {
      const jobModelSnapshotRetentionDays = Math.floor(+e.target.value);
      this.setJobDetails({
        jobModelSnapshotRetentionDays,
        ...(this.state.dailyModelSnapshotRetentionAfterDays > jobModelSnapshotRetentionDays ? {
          jobDailyModelSnapshotRetentionAfterDays: jobModelSnapshotRetentionDays
        } : {})
      });
    });
    (0, _defineProperty2.default)(this, "onDailyModelSnapshotRetentionAfterDaysChange", e => {
      const jobDailyModelSnapshotRetentionAfterDays = Math.floor(+e.target.value);
      if (jobDailyModelSnapshotRetentionAfterDays <= this.state.modelSnapshotRetentionDays) {
        this.setJobDetails({
          jobDailyModelSnapshotRetentionAfterDays
        });
      }
    });
    (0, _defineProperty2.default)(this, "onGroupsChange", selectedGroups => {
      this.setJobDetails({
        jobGroups: selectedGroups.map(g => g.label)
      });
    });
    (0, _defineProperty2.default)(this, "onCreateGroup", (input, flattenedOptions) => {
      const normalizedSearchValue = input.trim().toLowerCase();
      if (!normalizedSearchValue) {
        return;
      }
      const newGroup = {
        label: input
      };
      const groups = this.state.groups;
      // Create the option if it doesn't exist.
      if (flattenedOptions.findIndex(option => option.label.trim().toLowerCase() === normalizedSearchValue) === -1) {
        groups.push(newGroup);
      }
      const selectedGroups = this.state.selectedGroups.concat(newGroup);

      // update the groups in local state and call onGroupsChange to
      // update the selected groups in the component above which manages this
      // component's state
      this.setState({
        groups
      }, () => this.onGroupsChange(selectedGroups));
    });
    this.state = {
      description: '',
      groups: [],
      selectedGroups: [],
      mml: '',
      mmlValidationError: '',
      groupsValidationError: '',
      modelSnapshotRetentionDays: 1,
      dailyModelSnapshotRetentionAfterDays: 1
    };
    this.setJobDetails = props.setJobDetails;
  }
  componentDidMount() {
    // load groups to populate the select options
    _ml_api_service.ml.jobs.groups().then(resp => {
      const groups = resp.map(g => ({
        label: g.id,
        color: (0, _group_color_utils.tabColor)(g.id)
      }));
      this.setState({
        groups
      });
    }).catch(error => {
      console.error('Could not load groups', error);
    });
  }
  static getDerivedStateFromProps(props) {
    const selectedGroups = props.jobGroups !== undefined ? props.jobGroups.map(g => ({
      label: g,
      color: (0, _group_color_utils.tabColor)(g)
    })) : [];
    const {
      datafeedRunning,
      jobClosed
    } = props;
    let mmlHelpText = null;
    if (!jobClosed) {
      mmlHelpText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.jobsList.editJobFlyout.jobDetails.modelMemoryLimitJobOpenLabelHelp",
        defaultMessage: "Model memory limit cannot be edited while the job is open."
      });
    }
    if (datafeedRunning) {
      mmlHelpText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.jobsList.editJobFlyout.jobDetails.modelMemoryLimitLabelHelp",
        defaultMessage: "Model memory limit cannot be edited while the datafeed is running."
      });
    }
    return {
      description: props.jobDescription,
      selectedGroups,
      mml: props.jobModelMemoryLimit,
      mmlHelpText,
      mmlValidationError: props.jobModelMemoryLimitValidationError,
      groupsValidationError: props.jobGroupsValidationError,
      modelSnapshotRetentionDays: props.jobModelSnapshotRetentionDays,
      dailyModelSnapshotRetentionAfterDays: props.jobDailyModelSnapshotRetentionAfterDays
    };
  }
  render() {
    const {
      description,
      selectedGroups,
      mml,
      groups,
      mmlValidationError,
      groupsValidationError,
      modelSnapshotRetentionDays,
      dailyModelSnapshotRetentionAfterDays,
      mmlHelpText
    } = this.state;
    const {
      datafeedRunning,
      jobClosed
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.jobsList.editJobFlyout.jobDetails.jobDescriptionLabel",
        defaultMessage: "Job description"
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: description,
      onChange: this.onDescriptionChange
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.jobsList.editJobFlyout.jobDetails.jobGroupsLabel",
        defaultMessage: "Job groups"
      }),
      isInvalid: groupsValidationError !== '',
      error: groupsValidationError
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      placeholder: _i18n.i18n.translate('xpack.ml.jobsList.editJobFlyout.jobDetails.jobGroupsPlaceholder', {
        defaultMessage: 'Select or create groups'
      }),
      options: groups,
      selectedOptions: selectedGroups,
      onChange: this.onGroupsChange,
      onCreateOption: this.onCreateGroup,
      isClearable: true,
      isInvalid: groupsValidationError !== '',
      error: groupsValidationError
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.jobsList.editJobFlyout.jobDetails.modelMemoryLimitLabel",
        defaultMessage: "Model memory limit"
      }),
      helpText: mmlHelpText,
      isInvalid: mmlValidationError !== '',
      error: mmlValidationError
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: mml,
      onChange: this.onMmlChange,
      isInvalid: mmlValidationError !== '',
      error: mmlValidationError,
      disabled: datafeedRunning || !jobClosed
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.jobsList.editJobFlyout.jobDetails.modelSnapshotRetentionDaysLabel",
        defaultMessage: "Model snapshot retention days"
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      min: 0,
      value: modelSnapshotRetentionDays,
      onChange: this.onModelSnapshotRetentionDaysChange
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.jobsList.editJobFlyout.jobDetails.dailyModelSnapshotRetentionAfterDaysLabel",
        defaultMessage: "Daily model snapshot retention after days"
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      min: 0,
      max: modelSnapshotRetentionDays,
      value: dailyModelSnapshotRetentionAfterDays,
      onChange: this.onDailyModelSnapshotRetentionAfterDaysChange
    }))));
  }
}
exports.JobDetails = JobDetails;
JobDetails.propTypes = {
  datafeedRunning: _propTypes.default.bool.isRequired,
  jobDescription: _propTypes.default.string.isRequired,
  jobGroups: _propTypes.default.array.isRequired,
  jobModelMemoryLimit: _propTypes.default.string.isRequired,
  setJobDetails: _propTypes.default.func.isRequired
};