"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteJobModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _utils = require("../utils");
var _jobs_list = require("../../../../../../common/constants/jobs_list");
var _delete_space_aware_item_check_modal = require("../../../../components/delete_space_aware_item_check_modal");
var _jobs_utils = require("../../../jobs_utils");
var _managed_jobs_warning_callout = require("../confirm_modals/managed_jobs_warning_callout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DeleteJobModal = ({
  setShowFunction,
  unsetShowFunction,
  refreshJobs
}) => {
  const [deleting, setDeleting] = (0, _react.useState)(false);
  const [modalVisible, setModalVisible] = (0, _react.useState)(false);
  const [jobIds, setJobIds] = (0, _react.useState)([]);
  const [canDelete, setCanDelete] = (0, _react.useState)(false);
  const [hasManagedJob, setHasManagedJob] = (0, _react.useState)(false);
  const [deleteUserAnnotations, setDeleteUserAnnotations] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (typeof setShowFunction === 'function') {
      setShowFunction(showModal);
    }
    return () => {
      if (typeof unsetShowFunction === 'function') {
        unsetShowFunction();
      }
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const showModal = (0, _react.useCallback)(jobs => {
    setJobIds(jobs.map(({
      id
    }) => id));
    setHasManagedJob(jobs.some(job => (0, _jobs_utils.isManagedJob)(job)));
    setModalVisible(true);
    setDeleting(false);
    setDeleteUserAnnotations(false);
  }, []);
  const closeModal = (0, _react.useCallback)(() => {
    setModalVisible(false);
    setCanDelete(false);
  }, []);
  const deleteJob = (0, _react.useCallback)(() => {
    setDeleting(true);
    (0, _utils.deleteJobs)(jobIds.map(id => ({
      id
    })), deleteUserAnnotations);
    setTimeout(() => {
      closeModal();
      refreshJobs();
    }, _jobs_list.DELETING_JOBS_REFRESH_INTERVAL_MS);
  }, [jobIds, deleteUserAnnotations, closeModal, refreshJobs]);
  if (modalVisible === false || jobIds.length === 0) {
    return null;
  }
  if (canDelete) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
      "data-test-subj": "mlDeleteJobConfirmModal",
      onClose: closeModal
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.deleteJobModal.deleteJobsTitle",
      defaultMessage: "Delete {jobsCount, plural, one {{jobId}} other {# jobs}}?",
      values: {
        jobsCount: jobIds.length,
        jobId: jobIds[0]
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement("p", null, deleting === true ? /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.deleteJobModal.deletingJobsStatusLabel",
      defaultMessage: "Deleting jobs"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement("div", {
      style: {
        textAlign: 'center'
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "l"
    }))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, hasManagedJob ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_managed_jobs_warning_callout.ManagedJobsWarningCallout, {
      jobsCount: jobIds.length,
      action: _i18n.i18n.translate('xpack.ml.jobsList.deleteJobModal.deleteAction', {
        defaultMessage: 'deleting'
      })
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.deleteJobModal.deleteMultipleJobsDescription",
      defaultMessage: "Deleting {jobsCount, plural, one {a job} other {multiple jobs}} can be time consuming. {jobsCount, plural, one {It} other {They}} will be deleted in the background and may not disappear from the jobs list instantly.",
      values: {
        jobsCount: jobIds.length
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: _i18n.i18n.translate('xpack.ml.jobsList.deleteJobModal.deleteUserAnnotations', {
        defaultMessage: 'Delete annotations.'
      }),
      checked: deleteUserAnnotations,
      onChange: e => setDeleteUserAnnotations(e.target.checked),
      "data-test-subj": "mlDeleteJobConfirmModalDeleteAnnotationsSwitch"
    }))))), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: closeModal,
      disabled: deleting
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.deleteJobModal.cancelButtonLabel",
      defaultMessage: "Cancel"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: deleteJob,
      fill: true,
      disabled: deleting,
      color: "danger",
      "data-test-subj": "mlDeleteJobConfirmModalButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.deleteJobModal.deleteButtonLabel",
      defaultMessage: "Delete"
    })))));
  } else {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_delete_space_aware_item_check_modal.DeleteSpaceAwareItemCheckModal, {
      ids: jobIds,
      mlSavedObjectType: "anomaly-detector",
      canDeleteCallback: () => {
        setCanDelete(true);
      },
      onCloseCallback: closeModal,
      refreshJobsCallback: refreshJobs,
      hasManagedJob: hasManagedJob
    }));
  }
};
exports.DeleteJobModal = DeleteJobModal;