"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tabs = exports.TAB_IDS = exports.CHART_SIZE = exports.CHART_DIRECTION = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CHART_DIRECTION = {
  FORWARD: 'forward',
  BACK: 'back'
};
exports.CHART_DIRECTION = CHART_DIRECTION;
// [width, height]
const CHART_SIZE = ['100%', 380];
exports.CHART_SIZE = CHART_SIZE;
const TAB_IDS = {
  CHART: 'chart',
  MESSAGES: 'messages'
};
exports.TAB_IDS = TAB_IDS;
const tabs = [{
  id: TAB_IDS.CHART,
  name: _i18n.i18n.translate('xpack.ml.jobsList.datafeedChart.chartTabName', {
    defaultMessage: 'Chart'
  }),
  disabled: false
}, {
  id: TAB_IDS.MESSAGES,
  name: _i18n.i18n.translate('xpack.ml.jobsList.datafeedChart.messagesTabName', {
    defaultMessage: 'Messages'
  }),
  disabled: false
}];
exports.tabs = tabs;