"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyDetectionEmptyState = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _anomaly_detection_kibana = _interopRequireDefault(require("./anomaly_detection_kibana.png"));
var _locator = require("../../../../../../common/constants/locator");
var _kibana = require("../../../../contexts/kibana");
var _check_capabilities = require("../../../../capabilities/check_capabilities");
var _ml_nodes_check = require("../../../../ml_nodes_check");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AnomalyDetectionEmptyState = () => {
  const disableCreateAnomalyDetectionJob = !(0, _check_capabilities.checkPermission)('canCreateJob') || !(0, _ml_nodes_check.mlNodesAvailable)();
  const {
    services: {
      docLinks
    }
  } = (0, _kibana.useMlKibana)();
  const mlLocator = (0, _kibana.useMlLocator)();
  const navigateToPath = (0, _kibana.useNavigateToPath)();
  const redirectToCreateJobSelectIndexPage = async () => {
    if (!mlLocator) return;
    const path = await mlLocator.getUrl({
      page: _locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_SELECT_INDEX
    });
    await navigateToPath(path, true);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    layout: "horizontal",
    hasBorder: false,
    hasShadow: false,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      size: "fullWidth",
      src: _anomaly_detection_kibana.default,
      alt: "anomaly_detection"
    }),
    color: "subdued",
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.overview.anomalyDetection.createFirstJobMessage",
      defaultMessage: "Create your first anomaly detection job"
    })),
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.overview.anomalyDetection.emptyPromptText",
      defaultMessage: "Anomaly detection enables you to find unusual behavior in time series data. Start automatically spotting the anomalies hiding in your data and resolve issues faster."
    }))),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      onClick: redirectToCreateJobSelectIndexPage,
      fill: true,
      iconType: "plusInCircle",
      isDisabled: disableCreateAnomalyDetectionJob,
      "data-test-subj": "mlCreateNewJobButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.overview.anomalyDetection.createJobButtonText",
      defaultMessage: "Create job"
    })),
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: 'xs',
      alignItems: 'center'
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.common.learnMoreQuestion",
      defaultMessage: "Want to learn more?"
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: docLinks.links.ml.anomalyDetection,
      target: "_blank",
      external: true
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.common.readDocumentationLink",
      defaultMessage: "Read documentation"
    })))),
    "data-test-subj": "mlAnomalyDetectionEmptyState"
  });
};
exports.AnomalyDetectionEmptyState = AnomalyDetectionEmptyState;