"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getExplorerDefaultState = getExplorerDefaultState;
var _index_patterns = require("../../../../../common/constants/index_patterns");
var _explorer_charts_container_service = require("../../explorer_charts/explorer_charts_container_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getDefaultIndexPattern() {
  return {
    title: _index_patterns.ML_RESULTS_INDEX_PATTERN,
    fields: []
  };
}
function getExplorerDefaultState() {
  return {
    overallAnnotations: {
      error: undefined,
      annotationsData: []
    },
    annotations: {
      error: undefined,
      annotationsData: []
    },
    anomalyChartsDataLoading: true,
    chartsData: (0, _explorer_charts_container_service.getDefaultChartsData)(),
    fieldFormatsLoading: false,
    filterPlaceHolder: undefined,
    indexPattern: getDefaultIndexPattern(),
    influencers: {},
    isAndOperator: false,
    loading: true,
    maskAll: false,
    noInfluencersConfigured: true,
    queryString: '',
    selectedJobs: null,
    tableData: {
      anomalies: [],
      examplesByJobId: [''],
      interval: 0,
      jobIds: [],
      showViewSeriesLink: false
    },
    tableQueryString: ''
  };
}