"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExplorerChartsContainerUI = exports.ExplorerChartsContainer = void 0;
exports.getEntitiesQuery = getEntitiesQuery;
require("./_index.scss");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _chart_utils = require("../../util/chart_utils");
var _explorer_chart_distribution = require("./explorer_chart_distribution");
var _explorer_chart_single_metric = require("./explorer_chart_single_metric");
var _explorer_chart_label = require("./components/explorer_chart_label");
var _explorer_constants = require("../explorer_constants");
var _search = require("../../../../common/constants/search");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _chart_tooltip = require("../../components/chart_tooltip");
var _public = require("@kbn/kibana-react-plugin/public");
var _kibana = require("../../contexts/kibana");
var _aggregation_types = require("../../../../common/constants/aggregation_types");
var _util = require("../../../maps/util");
var _common = require("@kbn/maps-plugin/common");
var _public2 = require("@kbn/maps-plugin/public");
var _explorer_charts_error_callouts = require("./explorer_charts_error_callouts");
var _recently_accessed = require("../../util/recently_accessed");
var _explorer_chart_embedded_map = require("./explorer_chart_embedded_map");
var _public3 = require("@kbn/charts-plugin/public");
var _charts = require("@elastic/charts");
var _useObservable2 = _interopRequireDefault(require("react-use/lib/useObservable"));
var _string_utils = require("../../util/string_utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const textTooManyBuckets = _i18n.i18n.translate('xpack.ml.explorer.charts.tooManyBucketsDescription', {
  defaultMessage: 'This selection contains too many buckets to be displayed. You should shorten the time range of the view or narrow the selection in the timeline.'
});
const textViewButton = _i18n.i18n.translate('xpack.ml.explorer.charts.openInSingleMetricViewerButtonLabel', {
  defaultMessage: 'Open in Single Metric Viewer'
});
const mapsPluginMessage = _i18n.i18n.translate('xpack.ml.explorer.charts.mapsPluginMissingMessage', {
  defaultMessage: 'maps or embeddable start plugin not found'
});
const openInMapsPluginMessage = _i18n.i18n.translate('xpack.ml.explorer.charts.openInMapsPluginMessage', {
  defaultMessage: 'Open in Maps'
});
function getEntitiesQuery(series) {
  var _series$entityFields;
  const queryString = (_series$entityFields = series.entityFields) === null || _series$entityFields === void 0 ? void 0 : _series$entityFields.map(({
    fieldName,
    fieldValue
  }) => (0, _string_utils.escapeKueryForFieldValuePair)(fieldName, fieldValue)).join(' or ');
  const query = {
    language: _search.SEARCH_QUERY_LANGUAGE.KUERY,
    query: queryString
  };
  return {
    query,
    queryString
  };
}

// create a somewhat unique ID
// from charts metadata for React's key attribute
function getChartId(series) {
  const {
    jobId,
    detectorLabel,
    entityFields
  } = series;
  const entities = entityFields.map(ef => `${ef.fieldName}/${ef.fieldValue}`).join(',');
  const id = `${jobId}_${detectorLabel}_${entities}`;
  return id;
}

// Wrapper for a single explorer chart
function ExplorerChartContainer({
  series,
  severity,
  tooManyBuckets,
  wrapLabel,
  mlLocator,
  timeBuckets,
  timefilter,
  timeRange,
  onSelectEntity,
  recentlyAccessed,
  tooManyBucketsCalloutMsg,
  showSelectedInterval,
  chartsService
}) {
  var _useObservable;
  const [explorerSeriesLink, setExplorerSeriesLink] = (0, _react.useState)('');
  const [mapsLink, setMapsLink] = (0, _react.useState)('');
  const {
    services: {
      share,
      application: {
        navigateToApp
      }
    }
  } = (0, _kibana.useMlKibana)();
  const getMapsLink = (0, _react.useCallback)(async () => {
    const {
      queryString,
      query
    } = getEntitiesQuery(series);
    const initialLayers = (0, _util.getInitialAnomaliesLayers)(series.jobId);
    const locator = share.url.locators.get(_public2.MAPS_APP_LOCATOR);
    const location = await locator.getLocation({
      initialLayers: initialLayers,
      timeRange: timeRange !== null && timeRange !== void 0 ? timeRange : timefilter === null || timefilter === void 0 ? void 0 : timefilter.getTime(),
      ...(queryString !== undefined ? {
        query
      } : {})
    });
    return location;
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [series === null || series === void 0 ? void 0 : series.jobId, timeRange]);
  (0, _react.useEffect)(() => {
    let isCancelled = false;
    const generateLink = async () => {
      // Prioritize timeRange from embeddable panel or case
      // Else use the time range from data plugins's timefilters service
      let mergedTimeRange = timeRange;
      const bounds = timefilter === null || timefilter === void 0 ? void 0 : timefilter.getActiveBounds();
      if (!timeRange && bounds) {
        mergedTimeRange = {
          from: bounds.min.toISOString(),
          to: bounds.max.toISOString()
        };
      }
      if (!isCancelled && series.functionDescription !== _aggregation_types.ML_JOB_AGGREGATION.LAT_LONG) {
        try {
          const singleMetricViewerLink = await (0, _chart_utils.getExploreSeriesLink)(mlLocator, series, mergedTimeRange);
          setExplorerSeriesLink(singleMetricViewerLink);
        } catch (error) {
          setExplorerSeriesLink('');
        }
      }
    };
    generateLink();
    return () => {
      isCancelled = true;
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [mlLocator, series, timeRange]);
  (0, _react.useEffect)(function getMapsPluginLink() {
    let isCancelled = false;
    if (series && (0, _chart_utils.getChartType)(series) === _explorer_constants.CHART_TYPE.GEO_MAP) {
      const generateLink = async () => {
        try {
          const mapsLink = await getMapsLink();
          if (!isCancelled) {
            setMapsLink(mapsLink === null || mapsLink === void 0 ? void 0 : mapsLink.path);
          }
        } catch (error) {
          console.error(error);
          setMapsLink('');
        }
      };
      generateLink().catch(console.error);
    }
    return () => {
      isCancelled = true;
    };
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [series]);
  const chartRef = (0, _react.useRef)(null);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const chartTheme = chartsService.theme.useChartsTheme();
  const handleCursorUpdate = (0, _public3.useActiveCursor)(chartsService.activeCursor, chartRef, {
    isDateHistogram: true
  });
  const cursor = (_useObservable = (0, _useObservable2.default)(chartsService.activeCursor.activeCursor$)) === null || _useObservable === void 0 ? void 0 : _useObservable.cursor;
  const addToRecentlyAccessed = (0, _react.useCallback)(() => {
    if (recentlyAccessed) {
      (0, _recently_accessed.addItemToRecentlyAccessed)('timeseriesexplorer', series.jobId, explorerSeriesLink, recentlyAccessed);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [explorerSeriesLink, recentlyAccessed]);
  const {
    detectorLabel,
    entityFields
  } = series;
  const chartType = (0, _chart_utils.getChartType)(series);
  let DetectorLabel = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, detectorLabel);
  if (chartType === _explorer_constants.CHART_TYPE.EVENT_DISTRIBUTION) {
    const byField = series.entityFields.find(d => d.fieldType === 'by');
    if (typeof byField !== 'undefined') {
      DetectorLabel = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.explorer.charts.detectorLabel",
        defaultMessage: "{detectorLabel}{br}y-axis event distribution split by \"{fieldName}\"",
        values: {
          detectorLabel,
          br: /*#__PURE__*/_react.default.createElement("br", null),
          fieldName: byField.fieldName
        }
      }));
      wrapLabel = true;
    }
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 0,
      height: 0
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    ref: chartRef
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    noResults: /*#__PURE__*/_react.default.createElement("div", null),
    width: 0,
    height: 0
  }), /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: 'count',
    xAccessor: "x",
    yAccessors: ['y'],
    data: []
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_explorer_chart_label.ExplorerChartLabel, {
    detectorLabel: DetectorLabel,
    entityFields: entityFields,
    infoTooltip: {
      ...series.infoTooltip,
      chartType
    },
    wrapLabel: wrapLabel,
    onSelectEntity: onSelectEntity
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
              padding: ${euiTheme.size.xs};
            `
  }, tooManyBuckets && /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: tooManyBucketsCalloutMsg !== null && tooManyBucketsCalloutMsg !== void 0 ? tooManyBucketsCalloutMsg : textTooManyBuckets,
    position: "top",
    size: "s",
    type: "warning",
    color: "warning"
  }), explorerSeriesLink && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: textViewButton
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconSide: "right",
    iconType: "visLine",
    size: "xs",
    href: explorerSeriesLink,
    onClick: addToRecentlyAccessed
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.explorer.charts.viewLabel",
    defaultMessage: "View"
  }))), chartType === _explorer_constants.CHART_TYPE.GEO_MAP && mapsLink ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: openInMapsPluginMessage
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconSide: "right",
    iconType: "logoMaps",
    size: "xs",
    onClick: async () => {
      await navigateToApp(_common.APP_ID, {
        path: mapsLink
      });
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.explorer.charts.viewInMapsLabel",
    defaultMessage: "View"
  }))) : null))), (() => {
    if (chartType === _explorer_constants.CHART_TYPE.GEO_MAP) {
      return /*#__PURE__*/_react.default.createElement(_chart_tooltip.MlTooltipComponent, null, tooltipService => /*#__PURE__*/_react.default.createElement(_explorer_chart_embedded_map.EmbeddedMapComponentWrapper, {
        seriesConfig: series,
        tooltipService: tooltipService
      }));
    }
    if (chartType === _explorer_constants.CHART_TYPE.EVENT_DISTRIBUTION || chartType === _explorer_constants.CHART_TYPE.POPULATION_DISTRIBUTION) {
      return /*#__PURE__*/_react.default.createElement(_chart_tooltip.MlTooltipComponent, null, tooltipService => /*#__PURE__*/_react.default.createElement(_explorer_chart_distribution.ExplorerChartDistribution, {
        timeBuckets: timeBuckets,
        tooManyBuckets: tooManyBuckets,
        seriesConfig: series,
        severity: severity,
        tooltipService: tooltipService,
        showSelectedInterval: showSelectedInterval,
        onPointerUpdate: handleCursorUpdate,
        chartTheme: chartTheme,
        cursor: cursor
      }));
    }
    if (chartType === _explorer_constants.CHART_TYPE.SINGLE_METRIC) {
      return /*#__PURE__*/_react.default.createElement(_chart_tooltip.MlTooltipComponent, null, tooltipService => /*#__PURE__*/_react.default.createElement(_explorer_chart_single_metric.ExplorerChartSingleMetric, {
        timeBuckets: timeBuckets,
        tooManyBuckets: tooManyBuckets,
        seriesConfig: series,
        severity: severity,
        tooltipService: tooltipService,
        showSelectedInterval: showSelectedInterval,
        onPointerUpdate: handleCursorUpdate,
        chartTheme: chartTheme,
        cursor: cursor
      }));
    }
  })());
}

// Flex layout wrapper for all explorer charts
const ExplorerChartsContainerUI = ({
  chartsPerRow,
  seriesToPlot,
  severity,
  tooManyBuckets,
  kibana,
  errorMessages,
  mlLocator,
  timeBuckets,
  timefilter,
  timeRange,
  onSelectEntity,
  tooManyBucketsCalloutMsg,
  showSelectedInterval,
  chartsService
}) => {
  const {
    services: {
      chrome: {
        recentlyAccessed
      },
      embeddable: embeddablePlugin,
      maps: mapsPlugin
    }
  } = kibana;
  let seriesToPlotFiltered;
  if (!embeddablePlugin || !mapsPlugin) {
    seriesToPlotFiltered = [];
    // Show missing plugin callout
    seriesToPlot.forEach(series => {
      if (series.functionDescription === 'lat_long') {
        if (errorMessages[mapsPluginMessage] === undefined) {
          errorMessages[mapsPluginMessage] = new Set([series.jobId]);
        } else {
          errorMessages[mapsPluginMessage].add(series.jobId);
        }
      } else {
        seriesToPlotFiltered.push(series);
      }
    });
  }
  const seriesToUse = seriesToPlotFiltered !== undefined ? seriesToPlotFiltered : seriesToPlot;

  // <EuiFlexGrid> doesn't allow a setting of `columns={1}` when chartsPerRow would be 1.
  // If that's the case we trick it doing that with the following settings:
  const chartsWidth = chartsPerRow === 1 ? 'calc(100% - 20px)' : 'auto';
  const chartsColumns = chartsPerRow === 1 ? 0 : chartsPerRow;
  const wrapLabel = seriesToUse.some(series => (0, _chart_utils.isLabelLengthAboveThreshold)(series));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_explorer_charts_error_callouts.ExplorerChartsErrorCallOuts, {
    errorMessagesByType: errorMessages
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: chartsColumns,
    gutterSize: "m",
    "data-test-subj": "mlExplorerChartsContainer"
  }, seriesToUse.length > 0 && seriesToUse.map(series => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: getChartId(series),
    className: "ml-explorer-chart-container",
    style: {
      minWidth: chartsWidth
    }
  }, /*#__PURE__*/_react.default.createElement(ExplorerChartContainer, {
    series: series,
    severity: severity,
    tooManyBuckets: tooManyBuckets,
    wrapLabel: wrapLabel,
    mlLocator: mlLocator,
    timeBuckets: timeBuckets,
    timefilter: timefilter,
    timeRange: timeRange,
    onSelectEntity: onSelectEntity,
    recentlyAccessed: recentlyAccessed,
    tooManyBucketsCalloutMsg: tooManyBucketsCalloutMsg,
    showSelectedInterval: showSelectedInterval,
    chartsService: chartsService
  })))));
};
exports.ExplorerChartsContainerUI = ExplorerChartsContainerUI;
const ExplorerChartsContainer = (0, _public.withKibana)(ExplorerChartsContainerUI);
exports.ExplorerChartsContainer = ExplorerChartsContainer;