"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityFilter = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _anomaly_utils = require("../../../../../../../common/util/anomaly_utils");
var _component_utils = require("../../../../../util/component_utils");
require("./_entity_filter.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EntityFilter = ({
  onFilter,
  influencerFieldName,
  influencerFieldValue
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.entityFilter.addFilterTooltip",
      defaultMessage: "Add filter"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    size: "s",
    className: "filter-button",
    onClick: (0, _component_utils.blurButtonOnClick)(() => {
      onFilter({
        influencerFieldName,
        influencerFieldValue,
        action: _anomaly_utils.ENTITY_FIELD_OPERATIONS.ADD
      });
    }),
    iconType: "plusInCircle",
    "aria-label": _i18n.i18n.translate('xpack.ml.entityFilter.addFilterAriaLabel', {
      defaultMessage: 'Add filter for {influencerFieldName} {influencerFieldValue}',
      values: {
        influencerFieldName,
        influencerFieldValue
      }
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.entityFilter.removeFilterTooltip",
      defaultMessage: "Remove filter"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    size: "s",
    className: "filter-button",
    onClick: (0, _component_utils.blurButtonOnClick)(() => {
      onFilter({
        influencerFieldName,
        influencerFieldValue,
        action: _anomaly_utils.ENTITY_FIELD_OPERATIONS.REMOVE
      });
    }),
    iconType: "minusInCircle",
    "aria-label": _i18n.i18n.translate('xpack.ml.entityFilter.removeFilterAriaLabel', {
      defaultMessage: 'Remove filter for {influencerFieldName} {influencerFieldValue}',
      values: {
        influencerFieldName,
        influencerFieldValue
      }
    })
  })));
};
exports.EntityFilter = EntityFilter;