"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDashboardTable = void 0;
var _react = require("react");
var _lodash = require("lodash");
var _dashboard_service = require("../../services/dashboard_service");
var _kibana = require("../../contexts/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDashboardTable = () => {
  const {
    notifications: {
      toasts
    }
  } = (0, _kibana.useMlKibana)();
  const dashboardService = (0, _dashboard_service.useDashboardService)();
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    fetchDashboards();
    return () => {
      fetchDashboards.cancel();
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const search = (0, _react.useMemo)(() => {
    return {
      onChange: ({
        queryText
      }) => {
        setIsLoading(true);
        fetchDashboards(queryText);
      },
      box: {
        incremental: true,
        'data-test-subj': 'mlDashboardsSearchBox'
      }
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const [dashboardItems, setDashboardItems] = (0, _react.useState)([]);

  // eslint-disable-next-line react-hooks/exhaustive-deps
  const fetchDashboards = (0, _react.useCallback)((0, _lodash.debounce)(async query => {
    try {
      const response = await dashboardService.fetchDashboards(query);
      const items = response.savedObjects.map(savedObject => {
        return {
          id: savedObject.id,
          title: savedObject.attributes.title,
          description: savedObject.attributes.description,
          attributes: savedObject.attributes
        };
      });
      setDashboardItems(items);
    } catch (e) {
      toasts.danger({
        body: e
      });
    }
    setIsLoading(false);
  }, 500), []);
  return {
    dashboardItems,
    search,
    isLoading
  };
};
exports.useDashboardTable = useDashboardTable;