"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAddToDashboardActions = useAddToDashboardActions;
var _react = require("react");
var _public = require("@kbn/dashboard-plugin/public");
var _kibana = require("../../contexts/kibana");
var _dashboard_service = require("../../services/dashboard_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useAddToDashboardActions(type, getEmbeddableInput) {
  const {
    services: {
      embeddable
    }
  } = (0, _kibana.useMlKibana)();
  const dashboardService = (0, _dashboard_service.useDashboardService)();
  const addToDashboardAndEditCallback = (0, _react.useCallback)(async selectedDashboard => {
    const stateTransfer = embeddable.getStateTransfer();
    const selectedDashboardId = selectedDashboard.id;
    const dashboardPath = await dashboardService.getDashboardEditUrl(selectedDashboardId);
    await stateTransfer.navigateToWithEmbeddablePackage(_public.DASHBOARD_APP_ID, {
      path: dashboardPath,
      state: {
        type,
        input: getEmbeddableInput()
      }
    });
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [getEmbeddableInput]);
  return {
    addToDashboardAndEditCallback
  };
}