"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyExplorerContextProvider = exports.AnomalyExplorerContext = void 0;
exports.useAnomalyExplorerContext = useAnomalyExplorerContext;
var _react = _interopRequireWildcard(require("react"));
var _mlDatePicker = require("@kbn/ml-date-picker");
var _anomaly_timeline_state_service = require("./anomaly_timeline_state_service");
var _anomaly_explorer_common_state = require("./anomaly_explorer_common_state");
var _kibana = require("../contexts/kibana");
var _results_service = require("../services/results_service");
var _anomaly_timeline_service = require("../services/anomaly_timeline_service");
var _use_explorer_url_state = require("./hooks/use_explorer_url_state");
var _anomaly_charts_state_service = require("./anomaly_charts_state_service");
var _anomaly_explorer_charts_service = require("../services/anomaly_explorer_charts_service");
var _select_severity = require("../components/controls/select_severity");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Context of the Anomaly Explorer page.
 */
const AnomalyExplorerContext = /*#__PURE__*/_react.default.createContext(undefined);

/**
 * Hook for consuming {@link AnomalyExplorerContext}.
 */
exports.AnomalyExplorerContext = AnomalyExplorerContext;
function useAnomalyExplorerContext() {
  const context = (0, _react.useContext)(AnomalyExplorerContext);
  if (context === undefined) {
    throw new Error('AnomalyExplorerContext has not been initialized.');
  }
  return context;
}

/**
 * Anomaly Explorer Context Provider.
 */
const AnomalyExplorerContextProvider = ({
  children
}) => {
  const [,, anomalyExplorerUrlStateService] = (0, _use_explorer_url_state.useExplorerUrlState)();
  const timefilter = (0, _mlDatePicker.useTimefilter)();
  const {
    services: {
      mlServices: {
        mlApiServices
      },
      uiSettings
    }
  } = (0, _kibana.useMlKibana)();
  const [,, tableSeverityState] = (0, _select_severity.useTableSeverity)();

  // eslint-disable-next-line react-hooks/exhaustive-deps
  const mlResultsService = (0, _react.useMemo)(() => (0, _results_service.mlResultsServiceProvider)(mlApiServices), []);
  const [anomalyExplorerContextValue, setAnomalyExplorerContextValue] = (0, _react.useState)(undefined);
  (0, _react.useEffect)(() => {
    const anomalyTimelineService = new _anomaly_timeline_service.AnomalyTimelineService(timefilter, uiSettings, mlResultsService);
    const anomalyExplorerCommonStateService = new _anomaly_explorer_common_state.AnomalyExplorerCommonStateService(anomalyExplorerUrlStateService);
    const anomalyTimelineStateService = new _anomaly_timeline_state_service.AnomalyTimelineStateService(anomalyExplorerUrlStateService, anomalyExplorerCommonStateService, anomalyTimelineService, timefilter);
    const anomalyExplorerChartsService = new _anomaly_explorer_charts_service.AnomalyExplorerChartsService(timefilter, mlApiServices, mlResultsService);
    const chartsStateService = new _anomaly_charts_state_service.AnomalyChartsStateService(anomalyExplorerCommonStateService, anomalyTimelineStateService, anomalyExplorerChartsService, anomalyExplorerUrlStateService, tableSeverityState);
    setAnomalyExplorerContextValue({
      anomalyExplorerChartsService,
      anomalyExplorerCommonStateService,
      anomalyTimelineService,
      anomalyTimelineStateService,
      chartsStateService
    });
    return () => {
      // upon component unmounting
      // clear any data to prevent next page from rendering old charts
      anomalyExplorerCommonStateService.destroy();
      anomalyTimelineStateService.destroy();
      chartsStateService.destroy();
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  if (anomalyExplorerContextValue === undefined) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(AnomalyExplorerContext.Provider, {
    value: anomalyExplorerContextValue
  }, children);
};
exports.AnomalyExplorerContextProvider = AnomalyExplorerContextProvider;