"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyExplorerCommonStateService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _operators = require("rxjs/operators");
var _lodash = require("lodash");
var _state_service = require("../services/state_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Anomaly Explorer common state.
 * Manages related values in the URL state and applies required formatting.
 */
class AnomalyExplorerCommonStateService extends _state_service.StateService {
  _getDefaultFilterSettings() {
    return {
      filterActive: false,
      filteredFields: [],
      queryString: '',
      influencersFilterQuery: undefined
    };
  }
  constructor(anomalyExplorerUrlStateService) {
    super();
    (0, _defineProperty2.default)(this, "_selectedJobs$", new _rxjs.BehaviorSubject(undefined));
    (0, _defineProperty2.default)(this, "_filterSettings$", new _rxjs.BehaviorSubject(this._getDefaultFilterSettings()));
    (0, _defineProperty2.default)(this, "_smvJobs$", this.getSelectedJobs$().pipe((0, _operators.map)(jobs => jobs.filter(j => j.isSingleMetricViewerJob)), (0, _operators.shareReplay)(1)));
    this.anomalyExplorerUrlStateService = anomalyExplorerUrlStateService;
    this._init();
  }
  _initSubscriptions() {
    return this.anomalyExplorerUrlStateService.getPageUrlState$().pipe((0, _operators.map)(urlState => urlState === null || urlState === void 0 ? void 0 : urlState.mlExplorerFilter), (0, _operators.distinctUntilChanged)(_lodash.isEqual)).subscribe(v => {
      const result = {
        ...this._getDefaultFilterSettings(),
        ...v
      };
      this._filterSettings$.next(result);
    });
  }
  setSelectedJobs(explorerJobs) {
    this._selectedJobs$.next(explorerJobs);
  }
  getSelectedJobs$() {
    return this._selectedJobs$.pipe((0, _operators.filter)(v => Array.isArray(v) && v.length > 0), (0, _operators.distinctUntilChanged)(_lodash.isEqual), (0, _operators.shareReplay)(1));
  }
  getSingleMetricJobs$() {
    return this._smvJobs$;
  }
  getSelectedJobs() {
    return this._selectedJobs$.getValue();
  }
  getInfluencerFilterQuery$() {
    return this._filterSettings$.pipe((0, _operators.map)(v => v === null || v === void 0 ? void 0 : v.influencersFilterQuery), (0, _operators.distinctUntilChanged)(_lodash.isEqual));
  }
  getFilterSettings$() {
    return this._filterSettings$.asObservable();
  }
  getFilterSettings() {
    return this._filterSettings$.getValue();
  }
  setFilterSettings(update) {
    this.anomalyExplorerUrlStateService.updateUrlState({
      mlExplorerFilter: {
        influencersFilterQuery: update.filterQuery,
        filterActive: true,
        filteredFields: update.filteredFields,
        queryString: update.queryString
      }
    });
  }
  clearFilterSettings() {
    this.anomalyExplorerUrlStateService.updateUrlState({
      mlExplorerFilter: {}
    });
  }
}
exports.AnomalyExplorerCommonStateService = AnomalyExplorerCommonStateService;