"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCytoscapeOptions = void 0;
var _data_frame_analytics = require("../../../../../../common/constants/data_frame_analytics");
var _ml_classification_job = _interopRequireDefault(require("./icons/ml_classification_job.svg"));
var _ml_outlier_detection_job = _interopRequireDefault(require("./icons/ml_outlier_detection_job.svg"));
var _ml_regression_job = _interopRequireDefault(require("./icons/ml_regression_job.svg"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const lineColor = '#C5CCD7';
const MAP_SHAPES = {
  ELLIPSE: 'ellipse',
  RECTANGLE: 'rectangle',
  DIAMOND: 'diamond',
  TRIANGLE: 'triangle'
};
function shapeForNode(el, theme) {
  const type = el.data('type');
  switch (type) {
    case _data_frame_analytics.JOB_MAP_NODE_TYPES.ANALYTICS:
      return MAP_SHAPES.ELLIPSE;
    case _data_frame_analytics.JOB_MAP_NODE_TYPES.TRANSFORM:
      return MAP_SHAPES.RECTANGLE;
    case _data_frame_analytics.JOB_MAP_NODE_TYPES.INDEX:
      return MAP_SHAPES.DIAMOND;
    case _data_frame_analytics.JOB_MAP_NODE_TYPES.TRAINED_MODEL:
      return MAP_SHAPES.TRIANGLE;
    default:
      return MAP_SHAPES.ELLIPSE;
  }
}
function iconForNode(el) {
  const type = el.data('analysisType');
  switch (type) {
    case _data_frame_analytics.ANALYSIS_CONFIG_TYPE.OUTLIER_DETECTION:
      return _ml_outlier_detection_job.default;
    case _data_frame_analytics.ANALYSIS_CONFIG_TYPE.CLASSIFICATION:
      return _ml_classification_job.default;
    case _data_frame_analytics.ANALYSIS_CONFIG_TYPE.REGRESSION:
      return _ml_regression_job.default;
    default:
      return undefined;
  }
}
function borderColorForNode(el, theme) {
  if (el.selected()) {
    return theme.euiColorPrimary;
  }
  const type = el.data('type');
  switch (type) {
    case _data_frame_analytics.JOB_MAP_NODE_TYPES.ANALYTICS:
      return theme.euiColorSuccess;
    case _data_frame_analytics.JOB_MAP_NODE_TYPES.TRANSFORM:
      return theme.euiColorVis1;
    case _data_frame_analytics.JOB_MAP_NODE_TYPES.INDEX:
      return theme.euiColorVis2;
    case _data_frame_analytics.JOB_MAP_NODE_TYPES.TRAINED_MODEL:
      return theme.euiColorVis3;
    default:
      return theme.euiColorMediumShade;
  }
}
const getCytoscapeOptions = theme => ({
  autoungrabify: true,
  boxSelectionEnabled: false,
  maxZoom: 3,
  minZoom: 0.2,
  style: [{
    selector: 'node',
    style: {
      'background-color': el => el.data('isRoot') ? theme.euiColorWarning : theme.euiColorGhost,
      'background-height': '60%',
      'background-width': '60%',
      'border-color': el => borderColorForNode(el, theme),
      'border-style': 'solid',
      // @ts-ignore
      'background-image': el => iconForNode(el),
      'border-width': el => el.selected() ? 4 : 3,
      color: theme.euiTextColor,
      'font-family': 'Inter UI, Segoe UI, Helvetica, Arial, sans-serif',
      'font-size': theme.euiFontSizeXS,
      'min-zoomed-font-size': parseInt(theme.euiSizeL, 10),
      label: 'data(label)',
      shape: el => shapeForNode(el, theme),
      'text-background-color': theme.euiColorLightestShade,
      'text-background-opacity': 0,
      'text-background-padding': theme.euiSizeXS,
      'text-background-shape': 'roundrectangle',
      'text-margin-y': parseInt(theme.euiSizeS, 10),
      'text-max-width': '200px',
      'text-valign': 'bottom',
      'text-wrap': 'wrap'
    }
  }, {
    selector: 'edge',
    style: {
      'curve-style': 'taxi',
      // @ts-ignore
      'taxi-direction': 'rightward',
      'line-color': lineColor,
      'overlay-opacity': 0,
      'target-arrow-color': lineColor,
      'target-arrow-shape': 'triangle',
      // @ts-ignore
      'target-distance-from-node': theme.euiSizeXS,
      width: 1,
      'source-arrow-shape': 'none'
    }
  }]
});
exports.getCytoscapeOptions = getCytoscapeOptions;