"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyticsIdSelectorControls = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AnalyticsIdSelectorControls = ({
  setIsIdSelectorFlyoutVisible,
  selectedId
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  gutterSize: "xs",
  alignItems: "center"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, selectedId ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
  key: `${selectedId}-id`,
  "data-test-subj": `mlAnalyticsIdSelectionBadge ${selectedId}`,
  color: "hollow"
}, selectedId) : null, !selectedId ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: 'xs'
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.ml.dataframe.analytics.noIdsSelectedLabel",
  defaultMessage: "No Analytics ID selected"
})) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
  size: "xs",
  iconType: "pencil",
  onClick: setIsIdSelectorFlyoutVisible.bind(null, true),
  "data-test-subj": "mlButtonEditAnalyticsIdSelection"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.ml.dataframe.analytics.editSelection",
  defaultMessage: "Edit selection"
})))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null));
exports.AnalyticsIdSelectorControls = AnalyticsIdSelectorControls;