"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.startAnalytics = void 0;
var _i18n = require("@kbn/i18n");
var _ml_api_service = require("../../../../../services/ml_api_service");
var _common = require("../../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const startAnalytics = async (d, toastNotificationService) => {
  try {
    await _ml_api_service.ml.dataFrameAnalytics.startDataFrameAnalytics(d.config.id);
    toastNotificationService.displaySuccessToast(_i18n.i18n.translate('xpack.ml.dataframe.analyticsList.startAnalyticsSuccessMessage', {
      defaultMessage: 'Request to start data frame analytics {analyticsId} acknowledged.',
      values: {
        analyticsId: d.config.id
      }
    }));
  } catch (e) {
    toastNotificationService.displayErrorToast(e, _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.startAnalyticsErrorTitle', {
      defaultMessage: 'Error starting job'
    }));
  }
  _common.refreshAnalyticsList$.next(_common.REFRESH_ANALYTICS_LIST_STATE.REFRESH);
};
exports.startAnalytics = startAnalytics;