"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultDFAListState = exports.Page = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _i18nReact = require("@kbn/i18n-react");
var _mlUrlState = require("@kbn/ml-url-state");
var _analytics_list = require("./components/analytics_list");
var _use_refresh_interval = require("./components/analytics_list/use_refresh_interval");
var _node_available_warning = require("../../../components/node_available_warning");
var _saved_objects_warning = require("../../../components/saved_objects_warning");
var _upgrade = require("../../../components/upgrade");
var _job_map = require("../job_map");
var _common = require("./components/analytics_list/common");
var _locator = require("../../../../../common/constants/locator");
var _help_menu = require("../../../components/help_menu");
var _kibana = require("../../../contexts/kibana");
var _common2 = require("../../common");
var _page_header = require("../../../components/page_header");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDefaultDFAListState = () => ({
  pageIndex: 0,
  pageSize: 10,
  sortField: _common.DataFrameAnalyticsListColumn.id,
  sortDirection: 'asc'
});
exports.getDefaultDFAListState = getDefaultDFAListState;
const Page = () => {
  var _globalState$ml, _globalState$ml2;
  const [blockRefresh, setBlockRefresh] = (0, _react.useState)(false);
  const [globalState] = (0, _mlUrlState.useUrlState)('_g');
  const [dfaPageState, setDfaPageState] = (0, _mlUrlState.usePageUrlState)(_locator.ML_PAGES.DATA_FRAME_ANALYTICS_JOBS_MANAGE, getDefaultDFAListState());
  (0, _use_refresh_interval.useRefreshInterval)(setBlockRefresh);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const {
    refresh
  } = (0, _common2.useRefreshAnalyticsList)({
    isLoading: setIsLoading
  });
  const location = (0, _reactRouterDom.useLocation)();
  const selectedTabId = (0, _react.useMemo)(() => location.pathname.split('/').pop(), [location]);
  const mapJobId = globalState === null || globalState === void 0 ? void 0 : (_globalState$ml = globalState.ml) === null || _globalState$ml === void 0 ? void 0 : _globalState$ml.jobId;
  const mapModelId = globalState === null || globalState === void 0 ? void 0 : (_globalState$ml2 = globalState.ml) === null || _globalState$ml2 === void 0 ? void 0 : _globalState$ml2.modelId;
  const {
    services: {
      docLinks
    }
  } = (0, _kibana.useMlKibana)();
  const helpLink = docLinks.links.ml.dataFrameAnalytics;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeader, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analyticsList.title",
    defaultMessage: "Data Frame Analytics Jobs"
  })), /*#__PURE__*/_react.default.createElement(_node_available_warning.NodeAvailableWarning, null), /*#__PURE__*/_react.default.createElement(_saved_objects_warning.SavedObjectsWarning, {
    onCloseFlyout: refresh,
    forceRefresh: isLoading
  }), /*#__PURE__*/_react.default.createElement(_upgrade.UpgradeWarning, null), selectedTabId === 'map' && (mapJobId || mapModelId) && /*#__PURE__*/_react.default.createElement(_job_map.JobMap, {
    analyticsId: mapJobId,
    modelId: mapModelId
  }), selectedTabId === 'data_frame_analytics' && /*#__PURE__*/_react.default.createElement(_analytics_list.DataFrameAnalyticsList, {
    blockRefresh: blockRefresh,
    pageState: dfaPageState,
    updatePageState: setDfaPageState
  }), /*#__PURE__*/_react.default.createElement(_help_menu.HelpMenu, {
    docLink: helpLink
  }));
};
exports.Page = Page;