"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNSET_CONFIG_ITEM = exports.DEFAULT_NUM_TOP_FEATURE_IMPORTANCE_VALUES = exports.DEFAULT_MODEL_MEMORY_LIMIT = exports.DEFAULT_MAX_NUM_THREADS = void 0;
exports.getFormStateFromJobConfig = getFormStateFromJobConfig;
exports.getJobConfigFromFormState = exports.getInitialState = void 0;
var _check_capabilities = require("../../../../../capabilities/check_capabilities");
var _ml_nodes_check = require("../../../../../ml_nodes_check");
var _runtime_field_utils = require("../../../../../../../common/util/runtime_field_utils");
var _analytics = require("../../../../common/analytics");
var _analytics_utils = require("../../../../../../../common/util/analytics_utils");
var _data_frame_analytics = require("../../../../../../../common/constants/data_frame_analytics");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let DEFAULT_MODEL_MEMORY_LIMIT;
exports.DEFAULT_MODEL_MEMORY_LIMIT = DEFAULT_MODEL_MEMORY_LIMIT;
(function (DEFAULT_MODEL_MEMORY_LIMIT) {
  DEFAULT_MODEL_MEMORY_LIMIT["regression"] = "100mb";
  DEFAULT_MODEL_MEMORY_LIMIT["outlier_detection"] = "50mb";
  DEFAULT_MODEL_MEMORY_LIMIT["classification"] = "100mb";
})(DEFAULT_MODEL_MEMORY_LIMIT || (exports.DEFAULT_MODEL_MEMORY_LIMIT = DEFAULT_MODEL_MEMORY_LIMIT = {}));
const DEFAULT_NUM_TOP_FEATURE_IMPORTANCE_VALUES = 0;
exports.DEFAULT_NUM_TOP_FEATURE_IMPORTANCE_VALUES = DEFAULT_NUM_TOP_FEATURE_IMPORTANCE_VALUES;
const DEFAULT_MAX_NUM_THREADS = 1;
exports.DEFAULT_MAX_NUM_THREADS = DEFAULT_MAX_NUM_THREADS;
const UNSET_CONFIG_ITEM = '--';
exports.UNSET_CONFIG_ITEM = UNSET_CONFIG_ITEM;
const getInitialState = () => ({
  advancedEditorMessages: [],
  advancedEditorRawString: '',
  disableSwitchToForm: false,
  form: {
    alpha: undefined,
    computeFeatureInfluence: 'true',
    createIndexPattern: true,
    classAssignmentObjective: undefined,
    dependentVariable: '',
    description: '',
    destinationIndex: '',
    destinationIndexNameExists: false,
    destinationIndexNameEmpty: true,
    destinationIndexNameValid: false,
    destinationIndexPatternTitleExists: false,
    earlyStoppingEnabled: undefined,
    downsampleFactor: undefined,
    eta: undefined,
    etaGrowthRatePerTree: undefined,
    featureBagFraction: undefined,
    featureInfluenceThreshold: undefined,
    featureProcessors: undefined,
    gamma: undefined,
    includes: [],
    jobId: '',
    jobIdExists: false,
    jobIdEmpty: true,
    jobIdInvalidMaxLength: false,
    jobIdValid: false,
    jobType: undefined,
    jobConfigQuery: _analytics.defaultSearchQuery,
    jobConfigQueryString: undefined,
    jobConfigQueryLanguage: undefined,
    lambda: undefined,
    lossFunction: undefined,
    lossFunctionParameter: undefined,
    loadingFieldOptions: false,
    maxNumThreads: DEFAULT_MAX_NUM_THREADS,
    maxOptimizationRoundsPerHyperparameter: undefined,
    maxTrees: undefined,
    _meta: undefined,
    method: undefined,
    modelMemoryLimit: undefined,
    modelMemoryLimitUnitValid: true,
    modelMemoryLimitValidationResult: null,
    nNeighbors: undefined,
    numTopFeatureImportanceValues: DEFAULT_NUM_TOP_FEATURE_IMPORTANCE_VALUES,
    numTopFeatureImportanceValuesValid: true,
    numTopClasses: -1,
    outlierFraction: undefined,
    predictionFieldName: undefined,
    previousJobType: null,
    requiredFieldsError: undefined,
    randomizeSeed: undefined,
    resultsField: undefined,
    runtimeMappings: undefined,
    runtimeMappingsUpdated: false,
    previousRuntimeMapping: undefined,
    softTreeDepthLimit: undefined,
    softTreeDepthTolerance: undefined,
    sourceIndex: '',
    sourceIndexNameEmpty: true,
    sourceIndexNameValid: false,
    sourceIndexContainsNumericalFields: true,
    sourceIndexFieldsCheckFailed: false,
    standardizationEnabled: 'true',
    timeFieldName: undefined,
    trainingPercent: 80,
    useEstimatedMml: true
  },
  jobConfig: {},
  disabled: !(0, _ml_nodes_check.mlNodesAvailable)() || !(0, _check_capabilities.checkPermission)('canCreateDataFrameAnalytics') || !(0, _check_capabilities.checkPermission)('canStartStopDataFrameAnalytics'),
  indexPatternsMap: {},
  isAdvancedEditorEnabled: false,
  isAdvancedEditorValidJson: true,
  hasSwitchedToEditor: false,
  isJobCreated: false,
  isJobStarted: false,
  isValid: false,
  jobIds: [],
  requestMessages: [],
  estimatedModelMemoryLimit: ''
});
exports.getInitialState = getInitialState;
const getJobConfigFromFormState = formState => {
  const jobConfig = {
    description: formState.description,
    _meta: formState._meta,
    source: {
      // If a Kibana data view name includes commas, we need to split
      // the into an array of indices to be in the correct format for
      // the data frame analytics API.
      index: formState.sourceIndex.includes(',') ? formState.sourceIndex.split(',').map(d => d.trim()) : formState.sourceIndex,
      query: formState.jobConfigQuery,
      ...((0, _runtime_field_utils.isRuntimeMappings)(formState.runtimeMappings) ? {
        runtime_mappings: formState.runtimeMappings
      } : {})
    },
    dest: {
      index: formState.destinationIndex
    },
    analyzed_fields: {
      includes: formState.includes
    },
    analysis: {
      outlier_detection: {}
    },
    model_memory_limit: formState.modelMemoryLimit
  };
  if (formState.maxNumThreads !== undefined) {
    jobConfig.max_num_threads = formState.maxNumThreads;
  }
  const resultsFieldEmpty = typeof (formState === null || formState === void 0 ? void 0 : formState.resultsField) === 'string' && (formState === null || formState === void 0 ? void 0 : formState.resultsField.trim()) === '';
  if (jobConfig.dest && !resultsFieldEmpty) {
    jobConfig.dest.results_field = formState.resultsField;
  }
  if (formState.jobType === _data_frame_analytics.ANALYSIS_CONFIG_TYPE.REGRESSION || formState.jobType === _data_frame_analytics.ANALYSIS_CONFIG_TYPE.CLASSIFICATION) {
    let analysis = {
      dependent_variable: formState.dependentVariable,
      num_top_feature_importance_values: formState.numTopFeatureImportanceValues,
      training_percent: formState.trainingPercent
    };
    analysis = Object.assign(analysis, formState.alpha && {
      alpha: formState.alpha
    }, formState.eta && {
      eta: formState.eta
    }, formState.etaGrowthRatePerTree && {
      eta_growth_rate_per_tree: formState.etaGrowthRatePerTree
    }, formState.downsampleFactor && {
      downsample_factor: formState.downsampleFactor
    }, formState.featureBagFraction && {
      feature_bag_fraction: formState.featureBagFraction
    }, formState.featureProcessors && {
      feature_processors: formState.featureProcessors
    }, formState.gamma && {
      gamma: formState.gamma
    }, formState.lambda && {
      lambda: formState.lambda
    }, formState.lossFunction && {
      loss_function: formState.lossFunction
    }, formState.lossFunctionParameter && {
      loss_function_parameter: formState.lossFunctionParameter
    }, formState.maxOptimizationRoundsPerHyperparameter && {
      max_optimization_rounds_per_hyperparameter: formState.maxOptimizationRoundsPerHyperparameter
    }, formState.maxTrees && {
      max_trees: formState.maxTrees
    }, formState.randomizeSeed && {
      randomize_seed: formState.randomizeSeed
    }, formState.earlyStoppingEnabled !== undefined && {
      early_stopping_enabled: formState.earlyStoppingEnabled
    }, formState.predictionFieldName && {
      prediction_field_name: formState.predictionFieldName
    }, formState.randomizeSeed && {
      randomize_seed: formState.randomizeSeed
    }, formState.softTreeDepthLimit && {
      soft_tree_depth_limit: formState.softTreeDepthLimit
    }, formState.softTreeDepthTolerance && {
      soft_tree_depth_tolerance: formState.softTreeDepthTolerance
    });
    jobConfig.analysis = {
      [formState.jobType]: analysis
    };
  }
  if ((jobConfig === null || jobConfig === void 0 ? void 0 : jobConfig.analysis) !== undefined && (0, _analytics_utils.isClassificationAnalysis)(jobConfig === null || jobConfig === void 0 ? void 0 : jobConfig.analysis)) {
    if (formState.numTopClasses !== undefined) {
      jobConfig.analysis.classification.num_top_classes = formState.numTopClasses;
    }
    if (formState.classAssignmentObjective !== undefined) {
      jobConfig.analysis.classification.class_assignment_objective = formState.classAssignmentObjective;
    }
  }
  if (formState.jobType === _data_frame_analytics.ANALYSIS_CONFIG_TYPE.OUTLIER_DETECTION) {
    const analysis = Object.assign({}, formState.computeFeatureInfluence !== undefined && {
      compute_feature_influence: formState.computeFeatureInfluence
    }, formState.method && {
      method: formState.method
    }, formState.nNeighbors && {
      n_neighbors: formState.nNeighbors
    }, formState.outlierFraction && {
      outlier_fraction: formState.outlierFraction
    }, formState.featureInfluenceThreshold && {
      feature_influence_threshold: formState.featureInfluenceThreshold
    }, formState.standardizationEnabled !== undefined && {
      standardization_enabled: formState.standardizationEnabled
    });
    // @ts-ignore
    jobConfig.analysis.outlier_detection = analysis;
  }
  return jobConfig;
};
exports.getJobConfigFromFormState = getJobConfigFromFormState;
function toCamelCase(property) {
  const camelCased = property.replace(/_([a-z])/g, function (g) {
    return g[1].toUpperCase();
  });
  return camelCased;
}

/**
 * Extracts form state for a job clone from the analytics job configuration.
 * For cloning we keep job id and destination index empty.
 */
function getFormStateFromJobConfig(analyticsJobConfig, isClone = true) {
  var _analyticsJobConfig$d, _analyticsJobConfig$_, _analyticsJobConfig$a, _analyticsJobConfig$a2;
  const jobType = (0, _analytics.getAnalysisType)(analyticsJobConfig.analysis);
  const resultState = {
    jobType,
    description: (_analyticsJobConfig$d = analyticsJobConfig.description) !== null && _analyticsJobConfig$d !== void 0 ? _analyticsJobConfig$d : '',
    _meta: (_analyticsJobConfig$_ = analyticsJobConfig._meta) !== null && _analyticsJobConfig$_ !== void 0 ? _analyticsJobConfig$_ : {},
    resultsField: analyticsJobConfig.dest.results_field,
    sourceIndex: Array.isArray(analyticsJobConfig.source.index) ? analyticsJobConfig.source.index.join(',') : analyticsJobConfig.source.index,
    runtimeMappings: analyticsJobConfig.source.runtime_mappings,
    modelMemoryLimit: analyticsJobConfig.model_memory_limit,
    maxNumThreads: analyticsJobConfig.max_num_threads,
    includes: Array.isArray((_analyticsJobConfig$a = analyticsJobConfig.analyzed_fields) === null || _analyticsJobConfig$a === void 0 ? void 0 : _analyticsJobConfig$a.includes) ? (_analyticsJobConfig$a2 = analyticsJobConfig.analyzed_fields) === null || _analyticsJobConfig$a2 === void 0 ? void 0 : _analyticsJobConfig$a2.includes : [],
    jobConfigQuery: analyticsJobConfig.source.query || _analytics.defaultSearchQuery
  };
  if (isClone === false) {
    var _analyticsJobConfig$d2;
    resultState.destinationIndex = (_analyticsJobConfig$d2 = analyticsJobConfig === null || analyticsJobConfig === void 0 ? void 0 : analyticsJobConfig.dest.index) !== null && _analyticsJobConfig$d2 !== void 0 ? _analyticsJobConfig$d2 : '';
  }
  const analysisConfig = analyticsJobConfig.analysis[jobType];
  for (const key in analysisConfig) {
    if (analysisConfig.hasOwnProperty(key)) {
      const camelCased = toCamelCase(key);
      // @ts-ignore
      resultState[camelCased] = analysisConfig[key];
    }
  }
  return resultState;
}