"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DATA_FRAME_MODE = void 0;
Object.defineProperty(exports, "DATA_FRAME_TASK_STATE", {
  enumerable: true,
  get: function () {
    return _data_frame_analytics.DATA_FRAME_TASK_STATE;
  }
});
exports.DataFrameAnalyticsListColumn = void 0;
Object.defineProperty(exports, "Query", {
  enumerable: true,
  get: function () {
    return _eui.Query;
  }
});
exports.getDataFrameAnalyticsProgress = getDataFrameAnalyticsProgress;
exports.getDataFrameAnalyticsProgressPhase = getDataFrameAnalyticsProgressPhase;
exports.isCompletedAnalyticsJob = isCompletedAnalyticsJob;
exports.isDataFrameAnalyticsFailed = isDataFrameAnalyticsFailed;
exports.isDataFrameAnalyticsRunning = isDataFrameAnalyticsRunning;
exports.isDataFrameAnalyticsStats = isDataFrameAnalyticsStats;
exports.isDataFrameAnalyticsStopped = isDataFrameAnalyticsStopped;
var _eui = require("@elastic/eui");
var _data_frame_analytics = require("../../../../../../../common/constants/data_frame_analytics");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let DATA_FRAME_MODE;
exports.DATA_FRAME_MODE = DATA_FRAME_MODE;
(function (DATA_FRAME_MODE) {
  DATA_FRAME_MODE["BATCH"] = "batch";
  DATA_FRAME_MODE["CONTINUOUS"] = "continuous";
})(DATA_FRAME_MODE || (exports.DATA_FRAME_MODE = DATA_FRAME_MODE = {}));
function isDataFrameAnalyticsFailed(state) {
  return state === _data_frame_analytics.DATA_FRAME_TASK_STATE.FAILED;
}
function isDataFrameAnalyticsRunning(state) {
  return state === _data_frame_analytics.DATA_FRAME_TASK_STATE.ANALYZING || state === _data_frame_analytics.DATA_FRAME_TASK_STATE.REINDEXING || state === _data_frame_analytics.DATA_FRAME_TASK_STATE.STARTED || state === _data_frame_analytics.DATA_FRAME_TASK_STATE.STARTING;
}
function isDataFrameAnalyticsStopped(state) {
  return state === _data_frame_analytics.DATA_FRAME_TASK_STATE.STOPPED;
}
function isDataFrameAnalyticsStats(arg) {
  return typeof arg === 'object' && arg !== null && {}.hasOwnProperty.call(arg, 'state') && Object.values(_data_frame_analytics.DATA_FRAME_TASK_STATE).includes(arg.state) && {}.hasOwnProperty.call(arg, 'progress') && Array.isArray(arg.progress);
}
function getDataFrameAnalyticsProgress(stats) {
  if (isDataFrameAnalyticsStats(stats)) {
    return Math.round(stats.progress.reduce((p, c) => p + c.progress_percent, 0) / stats.progress.length);
  }
  return undefined;
}
function getDataFrameAnalyticsProgressPhase(stats) {
  let phase = 0;
  let progress = 0;
  for (const progressPhase of stats.progress) {
    phase++;
    progress = progressPhase.progress_percent;
    if (progressPhase.progress_percent < 100) {
      break;
    }
  }
  return {
    currentPhase: phase,
    progress,
    totalPhases: stats.progress.length
  };
}
// Used to pass on attribute names to table columns
const DataFrameAnalyticsListColumn = {
  configDestIndex: 'config.dest.index',
  configSourceIndex: 'config.source.index',
  configCreateTime: 'config.create_time',
  description: 'config.description',
  id: 'id',
  memoryStatus: 'stats.memory_usage.status'
};
exports.DataFrameAnalyticsListColumn = DataFrameAnalyticsListColumn;
function isCompletedAnalyticsJob(stats) {
  const progress = getDataFrameAnalyticsProgress(stats);
  return stats.state === _data_frame_analytics.DATA_FRAME_TASK_STATE.STOPPED && progress === 100;
}

// The single Action type is not exported as is
// from EUI so we use that code to get the single
// Action type from the array of actions.